/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshProcess;
import com.xebialabs.overthere.ssh.SshSftpConnection;
import com.xebialabs.overthere.util.OverthereUtils;
import java.util.List;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSftpCygwinConnection
extends SshSftpConnection {
    private static Logger logger = LoggerFactory.getLogger(SshSftpCygwinConnection.class);

    public SshSftpCygwinConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, SshSftpCygwinConnection.fixOptions(options), mapper);
        OverthereUtils.checkArgument(this.os == OperatingSystemFamily.WINDOWS, "Cannot create a ssh:%s connection to a host that is not running Windows", this.sshConnectionType.toString().toLowerCase());
    }

    private static ConnectionOptions fixOptions(ConnectionOptions options) {
        ConnectionOptions fixedOptions = new ConnectionOptions(options);
        fixedOptions.set("fileCopyCommandForWindows", "cmd /c " + fixedOptions.get("fileCopyCommandForWindows", "copy {0} {1} /y"));
        return fixedOptions;
    }

    @Override
    protected String pathToSftpPath(String path) {
        String translatedPath = this.toCygwinPath(path);
        if (translatedPath == null) {
            throw new RuntimeIOException(String.format("Cannot translate Windows path [%s] to a Cygdrive path because it is not a Windows path or a Cygwin path", path));
        }
        return translatedPath;
    }

    protected String toCygwinPath(String path) {
        if (path.length() >= 2 && path.charAt(1) == ':') {
            char driveLetter = Character.toLowerCase(path.charAt(0));
            String pathInDrive = path.substring(2).replace('\\', '/');
            String cygwinPath = "/cygdrive/" + driveLetter + pathInDrive;
            logger.trace("Translated Windows path [{}] to Cygdrive path [{}]", (Object)path, (Object)cygwinPath);
            return cygwinPath;
        }
        if (path.startsWith("/cygdrive/")) {
            return path;
        }
        return null;
    }

    @Override
    protected CmdLine processCommandLine(CmdLine cmd) {
        List<CmdLineArgument> args = cmd.getArguments();
        OverthereUtils.checkArgument(args.size() > 0, "Empty command line", new Object[0]);
        String arg0 = args.get(0).toString();
        String arg0CygwinPath = this.toCygwinPath(arg0);
        if (arg0CygwinPath != null) {
            CmdLine modifiedCommandLine = new CmdLine();
            modifiedCommandLine.add(CmdLineArgument.arg(arg0CygwinPath));
            for (int i = 1; i < args.size(); ++i) {
                modifiedCommandLine.add(args.get(i));
            }
            logger.trace("Translated first element (command) of command line from Windows path [{}] to Cygwin path [{}]", (Object)arg0, (Object)arg0CygwinPath);
            return super.processCommandLine(modifiedCommandLine);
        }
        return super.processCommandLine(cmd);
    }

    @Override
    protected SshProcess createProcess(Session session, CmdLine commandLine) throws TransportException, ConnectionException {
        return new SshProcess(this, OperatingSystemFamily.UNIX, session, commandLine);
    }
}

