/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshElevatedUserConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSuConnection
extends SshElevatedUserConnection {
    private static Logger logger = LoggerFactory.getLogger(SshSuConnection.class);

    public SshSuConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper);
        this.elevatedUsername = (String)options.get("suUsername");
        this.elevatedPassword = (String)options.get("suPassword");
        this.elevatedPasswordPromptRegex = options.get("suPasswordPromptRegex", ".*[Pp]assword.*:");
        this.elevationCommandPrefix = options.get("suCommandPrefix", "su - {0} -c");
        this.quoteCommand = options.getBoolean("suQuoteCommand", true);
        this.preserveAttributesOnCopyFromTempFile = options.getBoolean("suPreserveAttributesOnCopyFromTempFile", false);
        this.preserveAttributesOnCopyToTempFile = options.getBoolean("suPreserveAttributesOnCopyToTempFile", false);
        this.overrideUmask = options.getBoolean("suOverrideUmask", true);
        this.copyFromTempFileCommand = options.get("suCopyFromTempFileCommand", this.preserveAttributesOnCopyFromTempFile ? "cp -pr {0} {1}" : "cp -r {0} {1}");
        this.copyToTempFileCommand = options.get("suCopyToTempFileCommand", this.preserveAttributesOnCopyToTempFile ? "cp -pr {0} {1}" : "cp -r {0} {1}");
        this.overrideUmaskCommand = options.get("suOverrideUmaskCommand", "chmod -R go+rX {0}");
        this.tempMkdirCommand = options.get("suTempMkdirCommand", "mkdir -m 1777 {0}");
        this.tempMkdirsCommand = options.get("suTempMkdirsCommand", "mkdir -p -m 1777 {0}");
        SshSuConnection.checkElevatedPasswordPromptRegex(this, "suPasswordPromptRegex", logger);
    }
}

