/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class AuthManager
extends ConfigTestElement
implements Serializable {
    private static final long serialVersionUID = 233L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String AUTH_LIST = "AuthManager.auth_list";
    private static final String[] COLUMN_RESOURCE_NAMES = new String[]{"auth_base_url", "username", "password", "domain", "realm"};
    public static final int COL_URL = 0;
    public static final int COL_USERNAME = 1;
    public static final int COL_PASSWORD = 2;
    public static final int COL_DOMAIN = 3;
    public static final int COL_REALM = 4;
    private static final int COLUMN_COUNT = COLUMN_RESOURCE_NAMES.length;

    public AuthManager() {
        this.setProperty((JMeterProperty)new CollectionProperty(AUTH_LIST, new ArrayList()));
    }

    public void clear() {
        super.clear();
        this.setProperty((JMeterProperty)new CollectionProperty(AUTH_LIST, new ArrayList()));
    }

    public void set(int index, String url, String user, String pass, String domain, String realm) {
        Authorization auth = new Authorization(url, user, pass, domain, realm);
        if (index >= 0) {
            this.getAuthObjects().set(index, (JMeterProperty)new TestElementProperty(auth.getName(), (TestElement)auth));
        } else {
            this.getAuthObjects().addItem((Object)auth);
        }
    }

    public CollectionProperty getAuthObjects() {
        return (CollectionProperty)this.getProperty(AUTH_LIST);
    }

    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    public String getColumnName(int column) {
        return COLUMN_RESOURCE_NAMES[column];
    }

    public Class<?> getColumnClass(int column) {
        return COLUMN_RESOURCE_NAMES[column].getClass();
    }

    public Authorization getAuthObjectAt(int row) {
        return (Authorization)this.getAuthObjects().get(row).getObjectValue();
    }

    public boolean isEditable() {
        return true;
    }

    public Authorization get(int i) {
        return (Authorization)this.getAuthObjects().get(i).getObjectValue();
    }

    public String getAuthHeaderForURL(URL url) {
        Authorization auth = this.getAuthForURL(url);
        if (auth == null) {
            return null;
        }
        return auth.toBasicHeader();
    }

    public Authorization getAuthForURL(URL url) {
        if (!AuthManager.isSupportedProtocol(url)) {
            return null;
        }
        URL url2 = null;
        try {
            if (url.getPort() == -1) {
                int port = url.getProtocol().equalsIgnoreCase("http") ? 80 : 443;
                url2 = new URL(url.getProtocol(), url.getHost(), port, url.getPath());
            } else if (url.getPort() == 80 && url.getProtocol().equalsIgnoreCase("http") || url.getPort() == 443 && url.getProtocol().equalsIgnoreCase("https")) {
                url2 = new URL(url.getProtocol(), url.getHost(), url.getPath());
            }
        }
        catch (MalformedURLException e) {
            log.error("Internal error!", (Throwable)e);
        }
        String s1 = url.toString();
        String s2 = null;
        if (url2 != null) {
            s2 = url2.toString();
        }
        log.debug("Target URL strings to match against: " + s1 + " and " + s2);
        PropertyIterator iter = this.getAuthObjects().iterator();
        while (iter.hasNext()) {
            Authorization auth = (Authorization)iter.next().getObjectValue();
            String uRL = auth.getURL();
            log.debug("Checking match against auth'n entry: " + uRL);
            if (s1.startsWith(uRL) || s2 != null && s2.startsWith(uRL)) {
                log.debug("Matched");
                return auth;
            }
            log.debug("Did not match");
        }
        return null;
    }

    public void addConfigElement(ConfigElement config) {
    }

    public void addAuth(Authorization auth) {
        this.getAuthObjects().addItem((Object)auth);
    }

    public void addAuth() {
        this.getAuthObjects().addItem((Object)new Authorization());
    }

    public boolean expectsModification() {
        return false;
    }

    public void save(String authFile) throws IOException {
        File file = new File(authFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir"), authFile);
        }
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        writer.println("# JMeter generated Authorization file");
        for (int i = 0; i < this.getAuthObjects().size(); ++i) {
            Authorization auth = (Authorization)this.getAuthObjects().get(i).getObjectValue();
            writer.println(auth.toString());
        }
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(String authFile) throws IOException {
        File file = new File(authFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + authFile);
        }
        if (!file.canRead()) {
            throw new IOException("The file you specified cannot be read.");
        }
        BufferedReader reader = null;
        boolean ok = true;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                try {
                    if (line.startsWith("#") || JOrphanUtils.isBlank((String)line)) continue;
                    StringTokenizer st = new StringTokenizer(line, "\t");
                    String url = st.nextToken();
                    String user = st.nextToken();
                    String pass = st.nextToken();
                    String domain = "";
                    String realm = "";
                    if (st.hasMoreTokens()) {
                        domain = st.nextToken();
                        realm = st.nextToken();
                    }
                    Authorization auth = new Authorization(url, user, pass, domain, realm);
                    this.getAuthObjects().addItem((Object)auth);
                }
                catch (NoSuchElementException e) {
                    log.error("Error parsing auth line: '" + line + "'");
                    ok = false;
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        if (!ok) {
            JMeterUtils.reportErrorToUser((String)"One or more errors found when reading the Auth file - see the log file");
        }
    }

    public void remove(int index) {
        this.getAuthObjects().remove(index);
    }

    public int getAuthCount() {
        return this.getAuthObjects().size();
    }

    static boolean isSupportedProtocol(URL url) {
        String protocol = url.getProtocol().toLowerCase(Locale.ENGLISH);
        return protocol.equals("http") || protocol.equals("https");
    }
}

