/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier;

import java.io.Serializable;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;

public class ParamMask
extends AbstractTestElement
implements Serializable {
    private static final long serialVersionUID = 240L;
    private String PREFIX = "ParamModifier.prefix";
    private String FIELD_NAME = "ParamModifier.field_name";
    private String UPPER_BOUND = "ParamModifier.upper_bound";
    private String LOWER_BOUND = "ParamModifier.lower_bound";
    private String INCREMENT = "ParamModifier.increment";
    private String SUFFIX = "ParamModifier.suffix";
    private long _value = 0L;

    public ParamMask() {
        this.setFieldName("");
        this.setPrefix("");
        this.setLowerBound(0L);
        this.setUpperBound(0L);
        this.setIncrement(0L);
        this.setSuffix("");
    }

    public void setPrefix(String prefix) {
        this.setProperty(this.PREFIX, prefix);
    }

    public void setValue(long val) {
        this._value = val;
    }

    public void setFieldName(String fieldName) {
        this.setProperty(this.FIELD_NAME, fieldName);
    }

    public void setLowerBound(long val) {
        this.setProperty((JMeterProperty)new LongProperty(this.LOWER_BOUND, val));
    }

    public void setUpperBound(long val) {
        this.setProperty((JMeterProperty)new LongProperty(this.UPPER_BOUND, val));
    }

    public void setIncrement(long incr) {
        this.setProperty((JMeterProperty)new LongProperty(this.INCREMENT, incr));
    }

    public void setSuffix(String suffix) {
        this.setProperty(this.SUFFIX, suffix);
    }

    public String getPrefix() {
        return this.getPropertyAsString(this.PREFIX);
    }

    public long getLowerBound() {
        return this.getPropertyAsLong(this.LOWER_BOUND);
    }

    public long getUpperBound() {
        return this.getPropertyAsLong(this.UPPER_BOUND);
    }

    public long getIncrement() {
        return this.getPropertyAsLong(this.INCREMENT);
    }

    public String getSuffix() {
        return this.getPropertyAsString(this.SUFFIX);
    }

    public String getNextValue() {
        String retval = this.getPrefix() + Long.toString(this._value) + this.getSuffix();
        this._value += this.getIncrement();
        if (this._value > this.getUpperBound()) {
            this._value = this.getLowerBound();
        }
        return retval;
    }

    public void resetValue() {
        this._value = this.getLowerBound();
    }

    public String getFieldName() {
        return this.getPropertyAsString(this.FIELD_NAME);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-------------------------------\n");
        sb.append("Dumping ParamMask Object\n");
        sb.append("-------------------------------\n");
        sb.append("Name          = " + this.getFieldName() + "\n");
        sb.append("Prefix        = " + this.getPrefix() + "\n");
        sb.append("Current Value = " + this._value + "\n");
        sb.append("Lower Bound   = " + this.getLowerBound() + "\n");
        sb.append("Upper Bound   = " + this.getUpperBound() + "\n");
        sb.append("Increment     = " + this.getIncrement() + "\n");
        sb.append("Suffix        = " + this.getSuffix() + "\n");
        sb.append("-------------------------------\n");
        return sb.toString();
    }
}

