/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal;

import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.PropertyHelper;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

public class AntPropertyHelper
extends PropertyHelper {
    private Log log;
    private MavenProject mavenProject;

    public AntPropertyHelper(MavenProject project, Log l) {
        this.mavenProject = project;
        this.log = l;
    }

    public synchronized Object getPropertyHook(String ns, String name, boolean user) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("getProperty(ns=" + ns + ", name=" + name + ", user=" + user + ")"));
        }
        return this.getPropertyHook(ns, name, user, this.mavenProject);
    }

    private Object getPropertyHook(String ns, String name, boolean user, MavenProject mavenProject) {
        Object val = null;
        try {
            if (name.startsWith("project.")) {
                val = ReflectionValueExtractor.evaluate((String)name, (Object)mavenProject, (boolean)true);
            } else if (name.equals("basedir")) {
                val = ReflectionValueExtractor.evaluate((String)"basedir.path", (Object)mavenProject, (boolean)false);
            }
        }
        catch (Exception e) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((CharSequence)("Error evaluating expression '" + name + "'"), (Throwable)e);
            }
            e.printStackTrace();
        }
        if (val == null && (val = super.getPropertyHook(ns, name, user)) == null) {
            val = System.getProperty(name.toString());
        }
        return val;
    }
}

