/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.reader;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathReader {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathReader.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<URI> findURIs(String packagePrefix) {
        String filePath = this.packagePrefixToPath(packagePrefix);
        logger.debug("Finding resources for prefix: {}", (Object)filePath);
        ClassLoader contextClassLoader = this.getClassLoader();
        ArrayList<URI> uris = new ArrayList<URI>();
        try {
            Enumeration<URL> resources = contextClassLoader.getResources(filePath);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try {
                    logger.debug("Encountered URL: {}", (Object)url);
                    uris.add(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Could not convert URL: " + url + " to a URI", e);
                    return new HashSet<URI>(uris);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not fetch the resources matching " + filePath + " from the context classloader.", e);
        }
    }

    private String packagePrefixToPath(String packagePrefix) {
        return packagePrefix.replaceAll("\\.", "/");
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Set<URI> findBaseURIs(String prefix) {
        HashSet<URI> result = new HashSet<URI>();
        Set<URI> urIs = this.findURIs(prefix);
        String path = this.packagePrefixToPath(prefix);
        for (URI urI : urIs) {
            String schemeSpecificPart = urI.getSchemeSpecificPart();
            String based = schemeSpecificPart.substring(0, schemeSpecificPart.length() - path.length());
            try {
                result.add(new URI(urI.getScheme(), based, urI.getFragment()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        logger.debug("Found base uris: {}", result);
        return result;
    }
}

