/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractJDBCTestElement
extends AbstractTestElement
implements TestStateListener {
    private static final long serialVersionUID = 235L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String COMMA = ",";
    private static final char COMMA_CHAR = ',';
    private static final String UNDERSCORE = "_";
    private static final String NULL_MARKER = JMeterUtils.getPropDefault((String)"jdbcsampler.nullmarker", (String)"]NULL[");
    private static final String INOUT = "INOUT";
    private static final String OUT = "OUT";
    protected static final String ENCODING = "UTF-8";
    private static final Map<String, Integer> mapJdbcNameToInt = new HashMap<String, Integer>();
    static final String SELECT = "Select Statement";
    static final String UPDATE = "Update Statement";
    static final String CALLABLE = "Callable Statement";
    static final String PREPARED_SELECT = "Prepared Select Statement";
    static final String PREPARED_UPDATE = "Prepared Update Statement";
    static final String COMMIT = "Commit";
    static final String ROLLBACK = "Rollback";
    static final String AUTOCOMMIT_FALSE = "AutoCommit(false)";
    static final String AUTOCOMMIT_TRUE = "AutoCommit(true)";
    private String query = "";
    private String dataSource = "";
    private String queryType = "Select Statement";
    private String queryArguments = "";
    private String queryArgumentsTypes = "";
    private String variableNames = "";
    private String resultVariable = "";
    private static final Map<Connection, Map<String, PreparedStatement>> perConnCache;

    protected AbstractJDBCTestElement() {
    }

    /*
     * Exception decompiling
     */
    protected byte[] execute(Connection conn) throws SQLException, UnsupportedEncodingException, IOException, UnsupportedOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resultSetsToString(PreparedStatement pstmt, boolean result, int[] out) throws SQLException, UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        int updateCount = 0;
        if (!result) {
            updateCount = pstmt.getUpdateCount();
        }
        do {
            if (result) {
                ResultSet rs = null;
                try {
                    rs = pstmt.getResultSet();
                    sb.append(this.getStringFromResultSet(rs)).append("\n");
                }
                finally {
                    AbstractJDBCTestElement.close(rs);
                }
            } else {
                sb.append(updateCount).append(" updates.\n");
            }
            result = pstmt.getMoreResults();
            if (result) continue;
            updateCount = pstmt.getUpdateCount();
        } while (result || updateCount != -1);
        if (out != null && pstmt instanceof CallableStatement) {
            ArrayList<Object> outputValues = new ArrayList<Object>();
            CallableStatement cs = (CallableStatement)pstmt;
            sb.append("Output variables by position:\n");
            for (int i = 0; i < out.length; ++i) {
                if (out[i] == 0) continue;
                Object o = cs.getObject(i + 1);
                outputValues.add(o);
                sb.append("[");
                sb.append(i + 1);
                sb.append("] ");
                sb.append(o);
                sb.append("\n");
            }
            String[] varnames = this.getVariableNames().split(COMMA);
            if (varnames.length > 0) {
                JMeterVariables jmvars = this.getThreadContext().getVariables();
                for (int i = 0; i < varnames.length && i < outputValues.size(); ++i) {
                    String name = varnames[i].trim();
                    if (name.length() <= 0) continue;
                    Object o = outputValues.get(i);
                    jmvars.put(name, o == null ? null : o.toString());
                }
            }
        }
        return sb.toString();
    }

    private int[] setArguments(PreparedStatement pstmt) throws SQLException, IOException {
        String[] argumentsTypes;
        if (this.getQueryArguments().trim().length() == 0) {
            return new int[0];
        }
        String[] arguments = CSVSaveService.csvSplitString((String)this.getQueryArguments(), (char)',');
        if (arguments.length != (argumentsTypes = this.getQueryArgumentsTypes().split(COMMA)).length) {
            throw new SQLException("number of arguments (" + arguments.length + ") and number of types (" + argumentsTypes.length + ") are not equal");
        }
        int[] outputs = new int[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            String argumentType = argumentsTypes[i];
            String[] arg = argumentType.split(" ");
            String inputOutput = "";
            if (arg.length > 1) {
                argumentType = arg[1];
                inputOutput = arg[0];
            }
            int targetSqlType = AbstractJDBCTestElement.getJdbcType(argumentType);
            try {
                if (!OUT.equalsIgnoreCase(inputOutput)) {
                    if (argument.equals(NULL_MARKER)) {
                        pstmt.setNull(i + 1, targetSqlType);
                    } else {
                        pstmt.setObject(i + 1, (Object)argument, targetSqlType);
                    }
                }
                if (OUT.equalsIgnoreCase(inputOutput) || INOUT.equalsIgnoreCase(inputOutput)) {
                    CallableStatement cs = (CallableStatement)pstmt;
                    cs.registerOutParameter(i + 1, targetSqlType);
                    outputs[i] = targetSqlType;
                    continue;
                }
                outputs[i] = 0;
                continue;
            }
            catch (NullPointerException e) {
                throw new SQLException("Could not set argument no: " + (i + 1) + " - missing parameter marker?");
            }
        }
        return outputs;
    }

    private static int getJdbcType(String jdbcType) throws SQLException {
        Integer entry = mapJdbcNameToInt.get(jdbcType.toLowerCase(Locale.ENGLISH));
        if (entry == null) {
            try {
                entry = Integer.decode(jdbcType);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Invalid data type: " + jdbcType);
            }
        }
        return entry;
    }

    private CallableStatement getCallableStatement(Connection conn) throws SQLException {
        return (CallableStatement)this.getPreparedStatement(conn, true);
    }

    private PreparedStatement getPreparedStatement(Connection conn) throws SQLException {
        return this.getPreparedStatement(conn, false);
    }

    private PreparedStatement getPreparedStatement(Connection conn, boolean callable) throws SQLException {
        PreparedStatement pstmt;
        Map<String, PreparedStatement> preparedStatementMap = perConnCache.get(conn);
        if (null == preparedStatementMap) {
            preparedStatementMap = new ConcurrentHashMap<String, PreparedStatement>();
            perConnCache.put(conn, preparedStatementMap);
        }
        if (null == (pstmt = preparedStatementMap.get(this.getQuery()))) {
            pstmt = callable ? conn.prepareCall(this.getQuery()) : conn.prepareStatement(this.getQuery());
            preparedStatementMap.put(this.getQuery(), pstmt);
        }
        pstmt.clearParameters();
        return pstmt;
    }

    private static void closeAllStatements(Collection<PreparedStatement> collection) {
        for (PreparedStatement pstmt : collection) {
            AbstractJDBCTestElement.close(pstmt);
        }
    }

    private String getStringFromResultSet(ResultSet rs) throws SQLException, UnsupportedEncodingException {
        ResultSetMetaData meta = rs.getMetaData();
        StringBuilder sb = new StringBuilder();
        int numColumns = meta.getColumnCount();
        for (int i = 1; i <= numColumns; ++i) {
            sb.append(meta.getColumnName(i));
            if (i == numColumns) {
                sb.append('\n');
                continue;
            }
            sb.append('\t');
        }
        JMeterVariables jmvars = this.getThreadContext().getVariables();
        String[] varnames = this.getVariableNames().split(COMMA);
        String resultVariable = this.getResultVariable().trim();
        ArrayList results = null;
        if (resultVariable.length() > 0) {
            results = new ArrayList();
            jmvars.putObject(resultVariable, results);
        }
        int j = 0;
        while (rs.next()) {
            HashMap<String, Object> row = null;
            ++j;
            for (int i = 1; i <= numColumns; ++i) {
                String name;
                Object o = rs.getObject(i);
                if (results != null) {
                    if (row == null) {
                        row = new HashMap<String, Object>(numColumns);
                        results.add(row);
                    }
                    row.put(meta.getColumnName(i), o);
                }
                if (o instanceof byte[]) {
                    o = new String((byte[])o, ENCODING);
                }
                sb.append(o);
                if (i == numColumns) {
                    sb.append('\n');
                } else {
                    sb.append('\t');
                }
                if (i > varnames.length || (name = varnames[i - 1].trim()).length() <= 0) continue;
                jmvars.put(name + UNDERSCORE + j, o == null ? null : o.toString());
            }
        }
        for (int i = 0; i < varnames.length; ++i) {
            String name = varnames[i].trim();
            if (name.length() <= 0 || jmvars == null) continue;
            String varCount = name + "_#";
            String prevCount = jmvars.get(varCount);
            if (prevCount != null) {
                int prev = Integer.parseInt(prevCount);
                for (int n = j + 1; n <= prev; ++n) {
                    jmvars.remove(name + UNDERSCORE + n);
                }
            }
            jmvars.put(varCount, Integer.toString(j));
        }
        return sb.toString();
    }

    public static void close(Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException e) {
            log.warn("Error closing Connection", (Throwable)e);
        }
    }

    public static void close(Statement s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (SQLException e) {
            log.warn("Error closing Statement " + s.toString(), (Throwable)e);
        }
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.warn("Error closing ResultSet", (Throwable)e);
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("[");
        sb.append(this.getQueryType());
        sb.append("] ");
        sb.append(this.getQuery());
        sb.append("\n");
        sb.append(this.getQueryArguments());
        sb.append("\n");
        sb.append(this.getQueryArgumentsTypes());
        return sb.toString();
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public String getQueryArguments() {
        return this.queryArguments;
    }

    public void setQueryArguments(String queryArguments) {
        this.queryArguments = queryArguments;
    }

    public String getQueryArgumentsTypes() {
        return this.queryArgumentsTypes;
    }

    public void setQueryArgumentsTypes(String queryArgumentsType) {
        this.queryArgumentsTypes = queryArgumentsType;
    }

    public String getVariableNames() {
        return this.variableNames;
    }

    public void setVariableNames(String variableNames) {
        this.variableNames = variableNames;
    }

    public String getResultVariable() {
        return this.resultVariable;
    }

    public void setResultVariable(String resultVariable) {
        this.resultVariable = resultVariable;
    }

    public void testStarted() {
        this.testStarted("");
    }

    public void testStarted(String host) {
        AbstractJDBCTestElement.cleanCache();
    }

    public void testEnded() {
        this.testEnded("");
    }

    public void testEnded(String host) {
        AbstractJDBCTestElement.cleanCache();
    }

    private static final void cleanCache() {
        for (Map<String, PreparedStatement> element : perConnCache.values()) {
            AbstractJDBCTestElement.closeAllStatements(element.values());
        }
        perConnCache.clear();
    }

    static {
        Field[] fields = Types.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                String name = fields[i].getName();
                Integer value = (Integer)fields[i].get(null);
                mapJdbcNameToInt.put(name.toLowerCase(Locale.ENGLISH), value);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        perConnCache = new ConcurrentHashMap<Connection, Map<String, PreparedStatement>>();
    }
}

