/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class RepositoryItemAttributes {
    protected static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    protected long contentLength = -1L;
    protected long creation = -1L;
    protected Date creationDate;
    protected long lastModified = -1L;
    protected Date lastModifiedDate;
    protected String lastModifiedHttp;
    protected String mimeType;
    protected String weakETag;
    protected String strongETag;

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public long getCreation() {
        return this.creation;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        this.creation = creationDate.getTime();
    }

    public void setCreation(long creation) {
        this.creation = creation;
        this.creationDate = new Date(creation);
    }

    public void setCreationDateHttp(String creationDateValue) throws ParseException {
        this.creationDate = this.parseHttpDate(creationDateValue);
        this.creation = this.creationDate.getTime();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
        this.lastModifiedDate = new Date(lastModified);
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModified = lastModifiedDate.getTime();
        this.lastModifiedDate = lastModifiedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastModifiedHttp() {
        if (this.lastModifiedHttp != null) {
            return this.lastModifiedHttp;
        }
        Date modifiedDate = this.getLastModifiedDate();
        if (modifiedDate == null) {
            modifiedDate = this.getCreationDate();
        }
        if (modifiedDate == null) {
            modifiedDate = new Date();
        }
        SimpleDateFormat simpleDateFormat = format;
        synchronized (simpleDateFormat) {
            this.lastModifiedHttp = format.format(modifiedDate);
        }
        return this.lastModifiedHttp;
    }

    private Date parseHttpDate(String creationDate) throws ParseException {
        Date newCreationDate = null;
        for (int i = 0; newCreationDate == null && i < formats.length; ++i) {
            try {
                newCreationDate = formats[i].parse(creationDate);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (newCreationDate == null) {
            throw new ParseException("Exception while parsing http date", -1);
        }
        return newCreationDate;
    }

    public void setLastModifiedHttp(String lastModifiedHttp) throws ParseException {
        this.lastModifiedDate = this.parseHttpDate(lastModifiedHttp);
        this.lastModified = this.lastModifiedDate.getTime();
        this.lastModifiedHttp = lastModifiedHttp;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getETag() {
        String result = null;
        if (this.strongETag != null) {
            result = this.strongETag;
        } else {
            if (this.weakETag == null) {
                long contentLength = this.getContentLength();
                long lastModified = this.getLastModified();
                if (contentLength >= 0L || lastModified >= 0L) {
                    this.weakETag = "W/\"" + contentLength + "-" + lastModified + "\"";
                }
            }
            result = this.weakETag;
        }
        return result;
    }

    public void setETag(String eTag) {
        this.strongETag = eTag;
    }

    static {
        format.setTimeZone(gmtZone);
        formats[0].setTimeZone(gmtZone);
        formats[1].setTimeZone(gmtZone);
        formats[2].setTimeZone(gmtZone);
    }
}

