/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository.internal;

import javax.servlet.MultipartConfigElement;
import org.kurento.commons.ConfigFileManager;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.repository.Repository;
import org.kurento.repository.RepositoryApiConfiguration;
import org.kurento.repository.internal.repoimpl.filesystem.FileSystemRepository;
import org.kurento.repository.internal.repoimpl.mongo.MongoRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
public class RepositoryApplicationContextConfiguration {
    public static final String KEY_CONFIG_FILENAME = "kurento-repo.conf.json";
    public static final String KEY_REPO_HOST = "repository.hostname";
    public static final String KEY_REPO_PORT = "repository.port";
    public static final String KEY_REPO_TYPE = "repository.type";
    public static final String KEY_FS_FOLDER = "repository.filesystem.folder";
    public static final String KEY_MG_DB = "repository.mongodb.dbName";
    public static final String KEY_MG_GRID = "repository.mongodb.gridName";
    public static final String KEY_MG_URL = "repository.mongodb.urlConn";
    public static int SERVER_PORT;
    public static String SERVER_HOSTNAME;
    public static String REPO_TYPE;
    private static final Logger log;

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        return new MultipartConfigElement("");
    }

    @Bean
    public Repository repository() {
        RepositoryApiConfiguration repositoryApiConfiguration = this.repositoryApiConfiguration();
        RepositoryApiConfiguration.RepoType rtype = repositoryApiConfiguration.getRepositoryType();
        log.info("Repository type: {}", (Object)rtype);
        if (rtype.isFilesystem()) {
            return new FileSystemRepository();
        }
        if (rtype.isMongoDB()) {
            return new MongoRepository();
        }
        throw new KurentoException("Unrecognized repository type. Must be filesystem or mongodb");
    }

    @Bean(destroyMethod="shutdown")
    public TaskScheduler repositoryTaskScheduler() {
        return new ThreadPoolTaskScheduler();
    }

    @Bean
    public RepositoryApiConfiguration repositoryApiConfiguration() {
        RepositoryApiConfiguration config = new RepositoryApiConfiguration();
        config.setWebappPublicURL("http://" + SERVER_HOSTNAME + ":" + SERVER_PORT + "/");
        RepositoryApiConfiguration.RepoType type = RepositoryApiConfiguration.RepoType.parseType(REPO_TYPE);
        config.setRepositoryType(type);
        StringBuilder sb = new StringBuilder(type.getTypeValue());
        if (type.isFilesystem()) {
            String filesFolder = PropertiesManager.getProperty((String)KEY_FS_FOLDER, (String)config.getFileSystemFolder());
            config.setFileSystemFolder(filesFolder);
            sb.append("\n\t").append("folder : ").append(filesFolder);
        } else if (type.isMongoDB()) {
            String dbName = PropertiesManager.getProperty((String)KEY_MG_DB, (String)config.getMongoDatabaseName());
            config.setMongoDatabaseName(dbName);
            sb.append("\n\t").append("dbName : ").append(dbName);
            String grid = PropertiesManager.getProperty((String)KEY_MG_GRID, (String)config.getMongoGridFSCollectionName());
            config.setMongoGridFSCollectionName(grid);
            sb.append("\n\t").append("gridName : ").append(grid);
            String url = PropertiesManager.getProperty((String)KEY_MG_URL, (String)config.getMongoURLConnection());
            config.setMongoURLConnection(url);
            sb.append("\n\t").append("urlConn : ").append(url);
        }
        log.info("Repository config: {}", (Object)sb.toString());
        return config;
    }

    static {
        ConfigFileManager.loadConfigFile((String)KEY_CONFIG_FILENAME);
        SERVER_PORT = PropertiesManager.getProperty((String)KEY_REPO_PORT, (int)7676);
        SERVER_HOSTNAME = PropertiesManager.getProperty((String)KEY_REPO_HOST, (String)"localhost");
        REPO_TYPE = PropertiesManager.getProperty((String)KEY_REPO_TYPE, (String)RepositoryApiConfiguration.RepoType.MONGODB.getTypeValue());
        log = LoggerFactory.getLogger(RepositoryApplicationContextConfiguration.class);
    }
}

