/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository.internal.http;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.kurento.commons.SecretGenerator;
import org.kurento.repository.RepositoryApiConfiguration;
import org.kurento.repository.RepositoryHttpEndpoint;
import org.kurento.repository.RepositoryHttpPlayer;
import org.kurento.repository.RepositoryHttpRecorder;
import org.kurento.repository.RepositoryItem;
import org.kurento.repository.internal.RepositoryHttpEndpointImpl;
import org.kurento.repository.internal.RepositoryHttpPlayerImpl;
import org.kurento.repository.internal.RepositoryHttpRecorderImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;

@Component
public class RepositoryHttpManager {
    @Autowired
    private RepositoryApiConfiguration config;
    private String webappPublicURL;
    private String servletPath;
    private final ConcurrentMap<String, RepositoryHttpEndpointImpl> sessions = new ConcurrentHashMap<String, RepositoryHttpEndpointImpl>();
    private final SecretGenerator generator = new SecretGenerator();
    @Autowired
    @Qualifier(value="repositoryTaskScheduler")
    private TaskScheduler scheduler;

    public RepositoryHttpPlayer createRepositoryHttpPlayer(RepositoryItem repositoryItem) {
        return (RepositoryHttpPlayer)((Object)this.createRepositoryHttpElem(repositoryItem, RepositoryHttpPlayer.class, null));
    }

    public RepositoryHttpRecorder createRepositoryHttpRecorder(RepositoryItem repositoryItem) {
        return (RepositoryHttpRecorder)((Object)this.createRepositoryHttpElem(repositoryItem, RepositoryHttpRecorder.class, null));
    }

    public RepositoryHttpPlayer createRepositoryHttpPlayer(RepositoryItem repositoryItem, String sessionIdInURL) {
        return (RepositoryHttpPlayer)((Object)this.createRepositoryHttpElem(repositoryItem, RepositoryHttpPlayer.class, sessionIdInURL));
    }

    public RepositoryHttpRecorder createRepositoryHttpRecorder(RepositoryItem repositoryItem, String sessionIdInURL) {
        return (RepositoryHttpRecorder)((Object)this.createRepositoryHttpElem(repositoryItem, RepositoryHttpRecorder.class, sessionIdInURL));
    }

    private RepositoryHttpEndpointImpl createRepositoryHttpElem(RepositoryItem repositoryItem, Class<? extends RepositoryHttpEndpoint> repoItemHttpElemClass, String sessionIdInURL) {
        if (sessionIdInURL == null) {
            sessionIdInURL = this.createUniqueId();
        }
        String url = this.createUlr(sessionIdInURL);
        RepositoryHttpEndpointImpl elem = null;
        elem = repoItemHttpElemClass == RepositoryHttpPlayer.class ? new RepositoryHttpPlayerImpl(repositoryItem, sessionIdInURL, url, this) : new RepositoryHttpRecorderImpl(repositoryItem, sessionIdInURL, url, this);
        this.sessions.put(sessionIdInURL, elem);
        return elem;
    }

    private String createUniqueId() {
        return this.generator.nextSecret();
    }

    private String createUlr(String sessionId) {
        return this.webappPublicURL + this.getDispatchURL(sessionId);
    }

    public String getDispatchURL(String id) {
        return this.servletPath + id;
    }

    public RepositoryHttpEndpointImpl getHttpRepoItemElem(String sessionId) {
        return sessionId == null ? null : (RepositoryHttpEndpointImpl)this.sessions.get(sessionId);
    }

    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    public void disposeHttpRepoItemElem(String sessionId) {
        this.sessions.remove(sessionId);
    }

    public void disposeHttpRepoItemElemByItemId(RepositoryItem item, String message) {
        Iterator it = this.sessions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            RepositoryHttpEndpointImpl elem = (RepositoryHttpEndpointImpl)entry.getValue();
            if (!elem.getRepositoryItem().getId().equals(item.getId())) continue;
            elem.forceStopHttpManager(message);
            it.remove();
        }
    }

    public void setWebappPublicURL(String webappURL) {
        this.webappPublicURL = webappURL;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }
}

