/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository.internal.repoimpl;

import java.util.Map;
import org.kurento.repository.RepositoryHttpPlayer;
import org.kurento.repository.RepositoryHttpRecorder;
import org.kurento.repository.RepositoryItem;
import org.kurento.repository.RepositoryItemAttributes;
import org.kurento.repository.internal.repoimpl.RepositoryWithHttp;

public abstract class AbstractRepositoryItem
implements RepositoryItem {
    protected RepositoryWithHttp repository;
    protected String id;
    protected volatile RepositoryItem.State state;
    protected RepositoryItemAttributes attributes;
    protected Map<String, String> metadata;

    public AbstractRepositoryItem(String id, RepositoryItem.State state, RepositoryItemAttributes attributes, RepositoryWithHttp repository) {
        this.repository = repository;
        this.id = id;
        this.state = state;
        this.attributes = attributes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public RepositoryItem.State getState() {
        return this.state;
    }

    protected void checkState(RepositoryItem.State desiredState) {
        if (this.state != desiredState) {
            throw new IllegalStateException("The item is in state \"" + (Object)((Object)this.state) + "\" but is should be in state \"" + (Object)((Object)desiredState) + "\"");
        }
    }

    @Override
    public RepositoryHttpPlayer createRepositoryHttpPlayer() {
        return this.repository.getRepositoryHttpManager().createRepositoryHttpPlayer(this);
    }

    @Override
    public RepositoryHttpRecorder createRepositoryHttpRecorder() {
        return this.repository.getRepositoryHttpManager().createRepositoryHttpRecorder(this);
    }

    @Override
    public RepositoryHttpPlayer createRepositoryHttpPlayer(String sessionIdInURL) {
        return this.repository.getRepositoryHttpManager().createRepositoryHttpPlayer(this, sessionIdInURL);
    }

    @Override
    public RepositoryHttpRecorder createRepositoryHttpRecorder(String sessionIdInURL) {
        return this.repository.getRepositoryHttpManager().createRepositoryHttpRecorder(this, sessionIdInURL);
    }

    @Override
    public RepositoryItemAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public void putMetadataEntry(String key, String value) {
        this.metadata.put(key, value);
    }
}

