/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.blame;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceBlameConsumer
extends AbstractConsumer {
    private static final Pattern LINE_PATTERN = Pattern.compile("(\\d+):");
    private List<BlameLine> lines = new ArrayList<BlameLine>();

    public PerforceBlameConsumer(ScmLogger logger) {
        super(logger);
    }

    public void consumeLine(String line) {
        Matcher matcher = LINE_PATTERN.matcher(line);
        if (matcher.find()) {
            String revision = matcher.group(1).trim();
            this.lines.add(new BlameLine(null, revision, null));
        }
    }

    public List<BlameLine> getLines() {
        return this.lines;
    }
}

