/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.client;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.TimeoutReentrantLock;
import org.kurento.commons.TimeoutRuntimeException;
import org.kurento.commons.exception.KurentoException;
import org.kurento.jsonrpc.JsonRpcErrorException;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.TransportException;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.client.JsonRpcWSConnectionListener;
import org.kurento.jsonrpc.internal.JsonRpcRequestSenderHelper;
import org.kurento.jsonrpc.internal.client.ClientSession;
import org.kurento.jsonrpc.internal.client.TransactionImpl;
import org.kurento.jsonrpc.internal.ws.PendingRequests;
import org.kurento.jsonrpc.message.Message;
import org.kurento.jsonrpc.message.MessageUtils;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcClientWebSocket
extends JsonRpcClient {
    private static final int MAX_PACKET_SIZE = 1000000;
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("JsonRpcClientWebsocket-%d").build();
    public static Logger log = LoggerFactory.getLogger(JsonRpcClientWebSocket.class);
    public long requestTimeout = PropertiesManager.getProperty((String)"jsonRpcClientWebSocket.timeout", (int)60000);
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile ExecutorService execService;
    private volatile ExecutorService disconnectExecService;
    protected String url;
    private volatile Session wsSession;
    private final PendingRequests pendingRequests = new PendingRequests();
    private TransactionImpl.ResponseSender rs;
    private final SslContextFactory sslContextFactory;
    private final JsonRpcWSConnectionListener connectionListener;
    private WebSocketClient client;
    private boolean reconnecting;
    private TimeoutReentrantLock lock;
    private boolean sendCloseMessage;
    private boolean concurrentServerRequest = true;

    public JsonRpcClientWebSocket(String url) {
        this(url, null, null);
    }

    public JsonRpcClientWebSocket(String url, SslContextFactory sslContextFactory) {
        this(url, null, sslContextFactory);
    }

    public JsonRpcClientWebSocket(String url, JsonRpcWSConnectionListener connectionListener) {
        this(url, connectionListener, null);
    }

    public JsonRpcClientWebSocket(String url, JsonRpcWSConnectionListener connectionListener, SslContextFactory sslContextFactory) {
        this.lock = new TimeoutReentrantLock(15000L, "Server " + url);
        this.sslContextFactory = sslContextFactory;
        this.url = url;
        this.connectionListener = connectionListener;
        this.rsHelper = new JsonRpcRequestSenderHelper(){

            @Override
            protected void internalSendRequest(Request<? extends Object> request, Class<JsonElement> resultClass, Continuation<Response<JsonElement>> continuation) {
                JsonRpcClientWebSocket.this.internalSendRequestWebSocket(request, resultClass, continuation);
            }

            @Override
            public <P, R> Response<R> internalSendRequest(Request<P> request, Class<R> resultClass) throws IOException {
                return JsonRpcClientWebSocket.this.internalSendRequestWebSocket(request, resultClass);
            }
        };
    }

    @Override
    public void close() throws IOException {
        super.close();
        String sessionId = this.session != null ? this.session.getSessionId() : "";
        log.info("{} Explicit close of JsonRpcClientWebsocket with sessionId={}", (Object)this.label, (Object)sessionId);
        if (this.sendCloseMessage) {
            try {
                this.sendRequest("closeSession");
            }
            catch (Exception e) {
                log.warn("{} Exception sending close message. {}:{}", new Object[]{this.label, e.getClass().getName(), e.getMessage()});
            }
        }
        if (this.wsSession != null) {
            this.wsSession.close();
        } else {
            log.warn("{} Trying to close a JsonRpcClientWebSocket with wsSession=null", (Object)this.label);
        }
        this.pendingRequests.closeAllPendingRequests();
        this.closeClient();
    }

    public void setConcurrentServerRequest(boolean concurrentServerRequest) {
        this.concurrentServerRequest = concurrentServerRequest;
    }

    public boolean isConcurrentServerRequest() {
        return this.concurrentServerRequest;
    }

    @Override
    protected void closeWithReconnection() {
        log.info("{} Closing websocket session to force reconnection", (Object)this.label);
        this.wsSession.close();
        this.handleReconnectDisconnection(999, "ping timeout");
    }

    public void closeNativeSession() {
        this.wsSession.close();
    }

    @Override
    public void connect() throws IOException {
        this.connectIfNecessary();
    }

    public void connectIfNecessary() throws IOException {
        block18: {
            this.lock.tryLockTimeout("connectIfNecessary()");
            try {
                if (this.wsSession != null && this.wsSession.isOpen() || this.isClosed()) break block18;
                log.debug("{} Connecting webSocket client to server {}", (Object)this.label, (Object)this.url);
                try {
                    if (this.client == null) {
                        this.client = new WebSocketClient(this.sslContextFactory);
                        this.client.setConnectTimeout((long)this.connectionTimeout);
                        WebSocketPolicy policy = this.client.getPolicy();
                        policy.setMaxBinaryMessageBufferSize(1000000);
                        policy.setMaxTextMessageBufferSize(1000000);
                        policy.setMaxBinaryMessageSize(1000000);
                        policy.setMaxTextMessageSize(1000000);
                        this.client.start();
                    } else {
                        log.debug("{} Using existing websocket client when session is either null or closed.", (Object)this.label);
                    }
                    if (this.heartbeating) {
                        this.enableHeartbeat();
                    }
                    WebSocketClientSocket socket = new WebSocketClientSocket();
                    ClientUpgradeRequest request = new ClientUpgradeRequest();
                    this.wsSession = (Session)this.client.connect((Object)socket, new URI(this.url), request).get(this.connectionTimeout, TimeUnit.MILLISECONDS);
                    this.wsSession.setIdleTimeout((long)this.idleTimeout);
                }
                catch (TimeoutException e) {
                    this.fireConnectionFailed();
                    this.closeClient();
                    throw new KurentoException(this.label + " Timeout of " + this.connectionTimeout + "ms when waiting to connect to Websocket server " + this.url);
                }
                catch (Exception e) {
                    this.fireConnectionFailed();
                    this.closeClient();
                    throw new KurentoException(this.label + " Exception connecting to WebSocket server " + this.url, (Throwable)e);
                }
                try {
                    if (!this.latch.await(this.connectionTimeout, TimeUnit.MILLISECONDS)) {
                        this.fireConnectionFailed();
                        this.closeClient();
                        throw new KurentoException(this.label + " Timeout of " + this.connectionTimeout + "ms when waiting to connect to Websocket server " + this.url);
                    }
                    if (this.session == null) {
                        this.session = new ClientSession(null, null, this);
                        this.handlerManager.afterConnectionEstablished(this.session);
                        break block18;
                    }
                    try {
                        this.rsHelper.sendRequest("connect", String.class);
                        log.info("{} Reconnected to the same session in server {}", (Object)this.label, (Object)this.url);
                        this.fireReconnectedSameServer();
                    }
                    catch (JsonRpcErrorException e) {
                        if (e.getCode() == 40007) {
                            this.rsHelper.setSessionId(null);
                            this.rsHelper.sendRequest("connect", String.class);
                            this.pendingRequests.closeAllPendingRequests();
                            log.info("{} Reconnected to a new session in server {}", (Object)this.label, (Object)this.url);
                            this.fireReconnectedNewServer();
                            break block18;
                        }
                        log.warn("{} Error sending reconnection request to server ", new Object[]{this.label, this.url, e});
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (TimeoutRuntimeException e) {
                log.error("{} Timeout exception trying to acquire lock in JsonRpcWebSocket client to server {}. Closing this client.", new Object[]{this.label, this.url, e});
                this.closeClient();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void fireReconnectedNewServer() {
        if (this.connectionListener != null) {
            this.execService.submit(new Runnable(){

                @Override
                public void run() {
                    JsonRpcClientWebSocket.this.connectionListener.reconnected(false);
                }
            });
        }
    }

    private void fireReconnectedSameServer() {
        if (this.connectionListener != null) {
            this.execService.submit(new Runnable(){

                @Override
                public void run() {
                    JsonRpcClientWebSocket.this.connectionListener.reconnected(true);
                }
            });
        }
    }

    private void fireConnectionFailed() {
        if (this.connectionListener != null) {
            this.createExecServiceIfNecessary();
            this.execService.submit(new Runnable(){

                @Override
                public void run() {
                    JsonRpcClientWebSocket.this.connectionListener.connectionFailed();
                }
            });
        }
    }

    public Session getWebSocketSession() {
        return this.wsSession;
    }

    protected void handleReconnectDisconnection(int statusCode, final String closeReason) {
        if (!this.isClosed()) {
            this.reconnecting = true;
            this.createExecServiceIfNecessary();
            this.disconnectExecService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JsonRpcClientWebSocket.this.connectIfNecessary();
                        JsonRpcClientWebSocket.this.reconnecting = false;
                    }
                    catch (KurentoException e) {
                        log.debug("{} WebSocket closed due to: {}", (Object)JsonRpcClientWebSocket.this.label, (Object)closeReason);
                        JsonRpcClientWebSocket.this.pendingRequests.closeAllPendingRequests();
                        JsonRpcClientWebSocket.this.handlerManager.afterConnectionClosed(JsonRpcClientWebSocket.this.session, closeReason);
                        JsonRpcClientWebSocket.this.wsSession = null;
                        if (JsonRpcClientWebSocket.this.connectionListener != null) {
                            JsonRpcClientWebSocket.this.connectionListener.disconnected();
                        }
                    }
                    catch (IOException e) {
                        log.warn("{} Exception trying to reconnect to server {}", new Object[]{JsonRpcClientWebSocket.this.label, JsonRpcClientWebSocket.this.url, e});
                    }
                }
            });
        } else {
            this.pendingRequests.closeAllPendingRequests();
            this.handlerManager.afterConnectionClosed(this.session, closeReason);
            if (this.connectionListener != null) {
                this.connectionListener.disconnected();
            }
        }
    }

    private void createExecServiceIfNecessary() {
        this.lock.tryLockTimeout("createExecServiceIfNecessary");
        try {
            if (this.execService == null || this.execService.isShutdown() || this.execService.isTerminated()) {
                this.execService = Executors.newCachedThreadPool(threadFactory);
            }
            if (this.disconnectExecService == null || this.disconnectExecService.isShutdown() || this.disconnectExecService.isTerminated()) {
                this.disconnectExecService = Executors.newCachedThreadPool(threadFactory);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleRequestFromServer(final JsonObject message) {
        if (this.concurrentServerRequest) {
            this.createExecServiceIfNecessary();
            this.execService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        JsonRpcClientWebSocket.this.handlerManager.handleRequest(JsonRpcClientWebSocket.this.session, JsonUtils.fromJsonRequest(message, JsonElement.class), JsonRpcClientWebSocket.this.rs);
                    }
                    catch (IOException e) {
                        log.warn("{} Exception processing request {}", new Object[]{JsonRpcClientWebSocket.this.label, message, e});
                    }
                }
            });
        } else {
            log.debug("Submitting event to a current thread...");
            try {
                this.handlerManager.handleRequest(this.session, JsonUtils.fromJsonRequest(message, JsonElement.class), this.rs);
            }
            catch (Exception e) {
                log.warn("{} Exception processing request {}", new Object[]{this.label, message, e});
            }
        }
    }

    private void handleResponseFromServer(JsonObject message) {
        Response<JsonElement> response = JsonUtils.fromJsonResponse(message, JsonElement.class);
        this.setSessionId(response.getSessionId());
        this.pendingRequests.handleResponse(response);
    }

    private void handleWebSocketTextMessage(String message) {
        try {
            JsonObject jsonMessage = JsonUtils.fromJson(message, JsonObject.class);
            if (jsonMessage.has("method")) {
                this.handleRequestFromServer(jsonMessage);
            } else {
                this.handleResponseFromServer(jsonMessage);
            }
        }
        catch (Exception e) {
            log.error("{} Exception processing jsonRpc message {}", new Object[]{this.label, message, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <P> void internalSendRequestWebSocket(Request<P> request, final Class<JsonElement> resultClass, final Continuation<Response<JsonElement>> continuation) {
        try {
            boolean isPing;
            this.connectIfNecessary();
            ListenableFuture<Response<JsonElement>> responseFuture = null;
            if (request.getId() != null) {
                responseFuture = this.pendingRequests.prepareResponse(request.getId());
            }
            String jsonMessage = request.toString();
            if ("ping".equals(request.getMethod())) {
                isPing = true;
                log.trace("{} Req-> {}", (Object)this.label, (Object)jsonMessage.trim());
            } else {
                isPing = false;
                log.debug("{} Req-> {}", (Object)this.label, (Object)jsonMessage.trim());
            }
            if (this.wsSession == null) {
                throw new IllegalStateException(this.label + " JsonRpcClient is disconnected from WebSocket server at '" + this.url + "'");
            }
            Session session = this.wsSession;
            synchronized (session) {
                this.wsSession.getRemote().sendString(jsonMessage);
            }
            this.createExecServiceIfNecessary();
            if (responseFuture != null) {
                Futures.addCallback(responseFuture, (FutureCallback)new FutureCallback<Response<JsonElement>>(){

                    public void onSuccess(Response<JsonElement> responseJson) {
                        if (isPing) {
                            log.trace("{} <-Res {}", (Object)JsonRpcClientWebSocket.this.label, (Object)responseJson.toString());
                        } else {
                            log.debug("{} <-Res {}", (Object)JsonRpcClientWebSocket.this.label, (Object)responseJson.toString());
                        }
                        try {
                            Response response = MessageUtils.convertResponse(responseJson, resultClass);
                            if (response.getSessionId() != null) {
                                JsonRpcClientWebSocket.this.session.setSessionId(response.getSessionId());
                            }
                            continuation.onSuccess(response);
                        }
                        catch (Exception e) {
                            continuation.onError(e);
                        }
                    }

                    public void onFailure(Throwable thrown) {
                        continuation.onError(thrown);
                    }
                }, (Executor)this.execService);
            }
        }
        catch (Exception e) {
            continuation.onError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P, R> Response<R> internalSendRequestWebSocket(Request<P> request, Class<R> resultClass) throws IOException {
        this.connectIfNecessary();
        ListenableFuture<Response<JsonElement>> responseFuture = null;
        if (request.getId() != null) {
            responseFuture = this.pendingRequests.prepareResponse(request.getId());
        }
        boolean isPing = false;
        String jsonMessage = request.toString();
        if ("ping".equals(request.getMethod())) {
            isPing = true;
            log.trace("{} Req-> {}", (Object)this.label, (Object)jsonMessage.trim());
        } else {
            log.debug("{} Req-> {}", (Object)this.label, (Object)jsonMessage.trim());
        }
        if (this.wsSession == null) {
            throw new IllegalStateException(this.label + " JsonRpcClient is disconnected from WebSocket server at '" + this.url + "'");
        }
        Session session = this.wsSession;
        synchronized (session) {
            this.wsSession.getRemote().sendString(jsonMessage);
        }
        if (responseFuture == null) {
            return null;
        }
        try {
            Response responseJson = (Response)responseFuture.get(this.requestTimeout, TimeUnit.MILLISECONDS);
            if (isPing) {
                log.trace("{} <-Res {}", (Object)this.label, (Object)responseJson.toString());
            } else {
                log.debug("{} <-Res {}", (Object)this.label, (Object)responseJson.toString());
            }
            Response<R> response = MessageUtils.convertResponse(responseJson, resultClass);
            if (response.getSessionId() != null) {
                this.session.setSessionId(response.getSessionId());
            }
            return response;
        }
        catch (InterruptedException e) {
            throw new KurentoException(this.label + " Interrupted while waiting for a response", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new KurentoException(this.label + " This exception shouldn't be thrown", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new TransportException(this.label + " Timeout of " + this.requestTimeout + " milliseconds waiting from response to request " + jsonMessage.trim(), e);
        }
    }

    private synchronized void closeClient() {
        if (this.client != null) {
            log.debug("{} Closing client", (Object)this.label);
            try {
                this.client.stop();
                this.client.destroy();
            }
            catch (Exception e) {
                log.debug("{} Could not properly close websocket client. Reason: {}", (Object)this.label, (Object)e.getMessage());
            }
            this.client = null;
        }
        if (this.execService != null) {
            try {
                this.execService.shutdown();
            }
            catch (Exception e) {
                log.debug("{} Could not properly shut down executor service. Reason: {}", (Object)this.label, (Object)e.getMessage());
            }
            this.execService = null;
        }
        if (this.disconnectExecService != null) {
            try {
                this.disconnectExecService.shutdown();
            }
            catch (Exception e) {
                log.debug("{} Could not properly shut down disconnect executor service. Reason: {}", (Object)this.label, (Object)e.getMessage());
            }
            this.disconnectExecService = null;
        }
    }

    @Override
    public void setRequestTimeout(long timeout) {
        this.requestTimeout = timeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setSendCloseMessage(boolean sendCloseMessage) {
        this.sendCloseMessage = sendCloseMessage;
    }

    public boolean isSendCloseMessage() {
        return this.sendCloseMessage;
    }

    @WebSocket
    public class WebSocketClientSocket {
        @OnWebSocketClose
        public void onClose(int statusCode, String closeReason) {
            log.debug("Websocket disconnected by {} (status code {})", (Object)closeReason, (Object)statusCode);
            JsonRpcClientWebSocket.this.handleReconnectDisconnection(statusCode, closeReason);
        }

        @OnWebSocketConnect
        public void onConnect(Session session) {
            JsonRpcClientWebSocket.this.wsSession = session;
            JsonRpcClientWebSocket.this.rs = new TransactionImpl.ResponseSender(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sendResponse(Message message) throws IOException {
                    String jsonMessage = message.toString();
                    log.debug("{} <-Res {}", (Object)JsonRpcClientWebSocket.this.label, (Object)jsonMessage);
                    Session session = JsonRpcClientWebSocket.this.wsSession;
                    synchronized (session) {
                        JsonRpcClientWebSocket.this.wsSession.getRemote().sendString(jsonMessage);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sendPingResponse(Message message) throws IOException {
                    String jsonMessage = message.toString();
                    log.trace("{} <-Res {}", (Object)JsonRpcClientWebSocket.this.label, (Object)jsonMessage);
                    Session session = JsonRpcClientWebSocket.this.wsSession;
                    synchronized (session) {
                        JsonRpcClientWebSocket.this.wsSession.getRemote().sendString(jsonMessage);
                    }
                }
            };
            JsonRpcClientWebSocket.this.latch.countDown();
            if (JsonRpcClientWebSocket.this.connectionListener != null && !JsonRpcClientWebSocket.this.reconnecting) {
                JsonRpcClientWebSocket.this.connectionListener.connected();
            }
        }

        @OnWebSocketMessage
        public void onMessage(String message) {
            JsonRpcClientWebSocket.this.handleWebSocketTextMessage(message);
        }
    }
}

