/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.configuration;

import java.lang.reflect.Field;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.SpyAnnotationEngine;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.reflect.Whitebox;

public class PowerMockitoSpyAnnotationEngine
extends SpyAnnotationEngine {
    public void process(Class<?> context, Object testClass) {
        Field[] fields;
        for (Field field : fields = context.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Spy.class)) continue;
            try {
                Whitebox.invokeMethod((Object)((Object)this), (Object[])new Object[]{Spy.class, field, new Class[]{Mock.class, MockitoAnnotations.Mock.class, Captor.class}});
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            boolean wasAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                Object instance = field.get(testClass);
                if (instance == null) {
                    throw new MockitoException("Cannot create a @Spy for '" + field.getName() + "' field because the *instance* is missing\n" + "Example of correct usage of @Spy:\n" + "   @Spy List mock = new LinkedList();\n");
                }
                field.set(testClass, PowerMockito.spy(instance));
            }
            catch (IllegalAccessException e) {
                throw new MockitoException("Problems initiating spied field " + field.getName(), (Throwable)e);
            }
            finally {
                field.setAccessible(wasAccessible);
            }
        }
    }
}

