/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client;

import org.kurento.client.Continuation;
import org.kurento.client.KurentoObject;
import org.kurento.client.Transaction;
import org.kurento.client.internal.client.DefaultContinuation;
import org.kurento.client.internal.client.RemoteObject;
import org.kurento.client.internal.client.RemoteObjectInvocationHandler;
import org.kurento.client.internal.client.RomManager;
import org.kurento.jsonrpc.Props;

public class AbstractBuilder<T> {
    protected final Props props = new Props();
    private final RomManager manager;
    private final Class<?> clazz;

    public AbstractBuilder(Class<?> clazz, KurentoObject kurentoObject) {
        this.clazz = clazz;
        this.manager = RemoteObjectInvocationHandler.getFor(kurentoObject).getRomManager();
    }

    public AbstractBuilder(Class<?> clazz, RomManager manager) {
        this.clazz = clazz;
        this.manager = manager;
    }

    public T build() {
        RemoteObject remoteObject = this.manager.createWithKurentoObject(this.clazz, this.props);
        return (T)remoteObject.getKurentoObject();
    }

    public T build(Transaction transaction) {
        RemoteObject remoteObject = this.manager.createWithKurentoObject(this.clazz, this.props, transaction);
        return (T)remoteObject.getKurentoObject();
    }

    public void buildAsync(final Continuation<T> continuation) {
        this.manager.create(this.clazz.getSimpleName(), this.props, (Continuation<RemoteObject>)new DefaultContinuation<RemoteObject>(continuation){

            @Override
            public void onSuccess(RemoteObject remoteObject) {
                try {
                    continuation.onSuccess(RemoteObjectInvocationHandler.newProxy(remoteObject, AbstractBuilder.this.manager, AbstractBuilder.this.clazz));
                }
                catch (Exception e) {
                    log.warn("[Continuation] error invoking onSuccess implemented by client", (Throwable)e);
                }
            }
        });
    }
}

