/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client;

import com.google.common.base.StandardSystemProperty;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import javax.annotation.PreDestroy;
import org.kurento.client.AbstractBuilder;
import org.kurento.client.Continuation;
import org.kurento.client.JsonRpcConnectionListenerKurento;
import org.kurento.client.KurentoConnectionListener;
import org.kurento.client.KurentoObject;
import org.kurento.client.MediaPipeline;
import org.kurento.client.Properties;
import org.kurento.client.ServerManager;
import org.kurento.client.Transaction;
import org.kurento.client.internal.KmsUrlLoader;
import org.kurento.client.internal.TransactionImpl;
import org.kurento.client.internal.client.RomManager;
import org.kurento.client.internal.transport.jsonrpc.RomClientJsonRpcClient;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.client.JsonRpcClientWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KurentoClient {
    private static final int KEEPALIVE_TIME = 240000;
    private static Logger log = LoggerFactory.getLogger(KurentoClient.class);
    protected RomManager manager;
    private long requesTimeout = PropertiesManager.getProperty((String)"kurento.client.requestTimeout", (int)10000);
    private String id;
    private ServerManager serverManager;
    private JsonRpcClient client;
    private static KmsUrlLoader kmsUrlLoader;

    public static synchronized String getKmsUrl(String id, Properties properties) {
        Object load;
        if (kmsUrlLoader == null) {
            Path configFile = Paths.get(StandardSystemProperty.USER_HOME.value(), ".kurento", "config.properties");
            kmsUrlLoader = new KmsUrlLoader(configFile);
        }
        if ((load = properties.get("loadPoints")) == null) {
            return kmsUrlLoader.getKmsUrl(id);
        }
        if (load instanceof Number) {
            return kmsUrlLoader.getKmsUrlLoad(id, ((Number)load).intValue());
        }
        return kmsUrlLoader.getKmsUrlLoad(id, Integer.parseInt(load.toString()));
    }

    public static KurentoClient create() {
        return KurentoClient.create(new Properties());
    }

    public static KurentoClient create(Properties properties) {
        String id = UUID.randomUUID().toString();
        KurentoClient client = KurentoClient.create(KurentoClient.getKmsUrl(id, properties), properties);
        client.setId(id);
        return client;
    }

    private void setId(String id) {
        this.id = id;
    }

    public static KurentoClient create(String websocketUrl) {
        return KurentoClient.create(websocketUrl, new Properties());
    }

    public static KurentoClient create(String websocketUrl, Properties properties) {
        log.info("Connecting to kms in {}", (Object)websocketUrl);
        JsonRpcClientWebSocket client = new JsonRpcClientWebSocket(websocketUrl);
        KurentoClient.configureJsonRpcClient(client);
        return new KurentoClient((JsonRpcClient)client);
    }

    private static void configureJsonRpcClient(JsonRpcClientWebSocket client) {
        client.enableHeartbeat(240000);
        client.setLabel("KurentoClient");
        client.setSendCloseMessage(true);
    }

    public static KurentoClient create(String websocketUrl, KurentoConnectionListener listener) {
        return KurentoClient.create(websocketUrl, listener, new Properties());
    }

    public static KurentoClient create(String websocketUrl, KurentoConnectionListener listener, Properties properties) {
        log.info("Connecting to KMS in {}", (Object)websocketUrl);
        JsonRpcClientWebSocket client = new JsonRpcClientWebSocket(websocketUrl, JsonRpcConnectionListenerKurento.create(listener));
        KurentoClient.configureJsonRpcClient(client);
        return new KurentoClient((JsonRpcClient)client);
    }

    KurentoClient(JsonRpcClient client) {
        this.client = client;
        this.manager = new RomManager(new RomClientJsonRpcClient(client));
        client.setRequestTimeout(this.requesTimeout);
        if (client instanceof JsonRpcClientWebSocket) {
            ((JsonRpcClientWebSocket)client).enableHeartbeat(240000);
        }
        try {
            client.connect();
        }
        catch (IOException e) {
            throw new KurentoException("Exception connecting to KMS", (Throwable)e);
        }
    }

    public MediaPipeline createMediaPipeline() {
        return (MediaPipeline)new AbstractBuilder(MediaPipeline.class, this.manager).build();
    }

    public void createMediaPipeline(Continuation<MediaPipeline> cont) throws KurentoException {
        new AbstractBuilder<MediaPipeline>(MediaPipeline.class, this.manager).buildAsync(cont);
    }

    public MediaPipeline createMediaPipeline(Transaction tx) {
        return (MediaPipeline)new AbstractBuilder(MediaPipeline.class, this.manager).build(tx);
    }

    @PreDestroy
    public void destroy() {
        log.info("Closing KurentoClient");
        this.manager.destroy();
        if (kmsUrlLoader != null) {
            kmsUrlLoader.clientDestroyed(this.id);
        }
    }

    public boolean isClosed() {
        return this.manager.getRomClient().isClosed();
    }

    public static KurentoClient createFromJsonRpcClient(JsonRpcClient jsonRpcClient) {
        return new KurentoClient(jsonRpcClient);
    }

    public Transaction beginTransaction() {
        return new TransactionImpl(this.manager);
    }

    public ServerManager getServerManager() {
        if (this.serverManager == null) {
            this.serverManager = this.getById("manager_ServerManager", ServerManager.class);
        }
        return this.serverManager;
    }

    public <T extends KurentoObject> T getById(String id, Class<T> clazz) {
        return (T)((KurentoObject)this.manager.getById(id, clazz));
    }

    public String getSessionId() {
        return this.client.getSession().getSessionId();
    }
}

