/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.kurento.client.Continuation;
import org.kurento.client.KurentoObject;
import org.kurento.client.TFuture;
import org.kurento.client.Transaction;
import org.kurento.client.TransactionExecutionException;
import org.kurento.client.TransactionNotCommitedException;
import org.kurento.client.TransactionRollbackException;
import org.kurento.client.internal.TransactionImpl;
import org.kurento.client.internal.client.DefaultContinuation;
import org.kurento.client.internal.client.ListenerSubscriptionImpl;
import org.kurento.client.internal.client.RemoteObjectEventListener;
import org.kurento.client.internal.client.RomManager;
import org.kurento.client.internal.client.operation.InvokeOperation;
import org.kurento.client.internal.client.operation.ReleaseOperation;
import org.kurento.client.internal.client.operation.SubscriptionOperation;
import org.kurento.client.internal.client.operation.UnsubscriptionOperation;
import org.kurento.client.internal.transport.serialization.ParamsFlattener;
import org.kurento.jsonrpc.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteObject {
    private static Logger LOG = LoggerFactory.getLogger(RemoteObject.class);
    private static ParamsFlattener FLATTENER = ParamsFlattener.getInstance();
    private String objectRef;
    private final String type;
    private ObjectStatus objectStatus;
    private final RomManager manager;
    private KurentoObject kurentoObject;
    private volatile CountDownLatch readyLatch;
    private Continuation<Object> whenContinuation;
    private Executor executor;
    private final Multimap<String, RemoteObjectEventListener> listeners = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());
    private TransactionExecutionException transactionException;

    public RemoteObject(String objectRef, String type, RomManager manager) {
        this(objectRef, type, true, manager);
    }

    public RemoteObject(String objectRef, String type, boolean created, RomManager manager) {
        this.objectRef = objectRef;
        this.manager = manager;
        this.type = type;
        this.objectStatus = created ? ObjectStatus.CREATED : ObjectStatus.NOT_COMMITED;
        this.manager.registerObject(objectRef, this);
    }

    public boolean isCommited() {
        return this.objectStatus == ObjectStatus.CREATED;
    }

    public void waitCommited() throws InterruptedException {
        this.createReadyLatchIfNecessary();
        this.readyLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createReadyLatchIfNecessary() {
        if (this.readyLatch == null) {
            RemoteObject remoteObject = this;
            synchronized (remoteObject) {
                if (this.readyLatch == null) {
                    this.readyLatch = new CountDownLatch(1);
                }
            }
        }
    }

    public synchronized void whenCommited(Continuation<?> continuation) {
        this.whenCommited(continuation, null);
    }

    public synchronized void whenCommited(Continuation<?> continuation, Executor executor) {
        this.whenContinuation = continuation;
        this.executor = executor;
        if (this.isCommited()) {
            this.execWhenCommited();
        }
    }

    private void execWhenCommited() {
        if (this.executor == null) {
            try {
                this.whenContinuation.onSuccess(this.getKurentoObject());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        RemoteObject.this.whenContinuation.onSuccess(RemoteObject.this.getKurentoObject());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public KurentoObject getKurentoObject() {
        return this.kurentoObject;
    }

    public void setKurentoObject(KurentoObject kurentoObject) {
        this.kurentoObject = kurentoObject;
    }

    public String getObjectRef() {
        return this.objectRef;
    }

    public String getType() {
        return this.type;
    }

    public RomManager getRomManager() {
        return this.manager;
    }

    public <E> E invoke(String method, Props params, Class<E> clazz) {
        this.checkCreated();
        Type flattenType = FLATTENER.calculateFlattenType(clazz);
        Object obj = this.invoke(method, params, flattenType);
        return (E)FLATTENER.unflattenValue("return", clazz, obj, this.manager);
    }

    public Object invoke(String method, Props params, Type type) {
        this.checkCreated();
        if (method.equals("getId")) {
            return this.objectRef;
        }
        Type flattenType = FLATTENER.calculateFlattenType(type);
        Object obj = this.manager.invoke(this.objectRef, method, params, flattenType);
        return FLATTENER.unflattenValue("return", type, obj, this.manager);
    }

    public TFuture<Object> invoke(String method, Props params, Type type, Transaction tx) {
        TransactionImpl txImpl = (TransactionImpl)tx;
        InvokeOperation op = new InvokeOperation(this.getKurentoObject(), method, params, type);
        txImpl.addOperation(op);
        return op.getFuture();
    }

    public void invoke(String method, Props params, final Type type, final Continuation cont) {
        this.checkCreated();
        Type flattenType = FLATTENER.calculateFlattenType(type);
        this.manager.invoke(this.objectRef, method, params, flattenType, new DefaultContinuation<Object>(cont){

            @Override
            public void onSuccess(Object result) {
                try {
                    cont.onSuccess(FLATTENER.unflattenValue("return", type, result, RemoteObject.this.manager));
                }
                catch (Exception e) {
                    log.warn("[Continuation] error invoking onSuccess implemented by client", (Throwable)e);
                }
            }
        });
    }

    public void release() {
        this.checkCreated();
        this.manager.release(this.objectRef);
    }

    public void release(Transaction tx) {
        TransactionImpl txImpl = (TransactionImpl)tx;
        txImpl.addOperation(new ReleaseOperation(this.getKurentoObject()));
    }

    public void release(final Continuation<Void> cont) {
        this.checkCreated();
        this.manager.release(this.objectRef, (Continuation<Void>)new DefaultContinuation<Void>(cont){

            @Override
            public void onSuccess(Void result) {
                try {
                    cont.onSuccess(null);
                }
                catch (Exception e) {
                    log.warn("[Continuation] error invoking onSuccess implemented by client", (Throwable)e);
                }
            }
        });
    }

    public ListenerSubscriptionImpl addEventListener(String eventType, RemoteObjectEventListener listener) {
        this.checkCreated();
        String subscription = this.manager.subscribe(this.objectRef, eventType);
        this.listeners.put((Object)eventType, (Object)listener);
        return new ListenerSubscriptionImpl(subscription, eventType, listener);
    }

    public ListenerSubscriptionImpl addEventListener(String eventType, RemoteObjectEventListener listener, Transaction tx) {
        TransactionImpl txImpl = (TransactionImpl)tx;
        SubscriptionOperation op = new SubscriptionOperation(this.getKurentoObject(), eventType, listener);
        txImpl.addOperation(op);
        return op.getListenerSubscription();
    }

    public void addEventListener(final String eventType, final RemoteObjectEventListener listener, final Continuation<ListenerSubscriptionImpl> cont) {
        this.checkCreated();
        this.listeners.put((Object)eventType, (Object)listener);
        this.manager.subscribe(this.objectRef, eventType, (Continuation<String>)new DefaultContinuation<String>(cont){

            @Override
            public void onSuccess(String subscription) {
                try {
                    cont.onSuccess(new ListenerSubscriptionImpl(subscription, eventType, listener));
                }
                catch (Exception e) {
                    log.warn("[Continuation] error invoking onSuccess implemented by client", (Throwable)e);
                }
            }
        });
    }

    public void removeEventListener(ListenerSubscriptionImpl listenerSubscription) {
        this.checkCreated();
        this.listeners.remove((Object)listenerSubscription.getType(), (Object)listenerSubscription.getListener());
        this.manager.unsubscribe(this.objectRef, listenerSubscription.getSubscriptionId());
    }

    public void removeEventListener(ListenerSubscriptionImpl listenerSubscription, Transaction tx) {
        TransactionImpl txImpl = (TransactionImpl)tx;
        UnsubscriptionOperation op = new UnsubscriptionOperation(this.getKurentoObject(), listenerSubscription);
        txImpl.addOperation(op);
    }

    public void removeEventListener(ListenerSubscriptionImpl listenerSubscription, final Continuation<Void> cont) {
        this.checkCreated();
        this.listeners.remove((Object)listenerSubscription.getType(), (Object)listenerSubscription);
        this.manager.unsubscribe(this.objectRef, listenerSubscription.getSubscriptionId(), (Continuation<Void>)new DefaultContinuation<Void>(cont){

            @Override
            public void onSuccess(Void result) {
                try {
                    cont.onSuccess(result);
                }
                catch (Exception e) {
                    log.warn("[Continuation] error invoking onSuccess implemented by client", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(String type, Props data) {
        ArrayList typeListeners;
        Multimap<String, RemoteObjectEventListener> multimap = this.listeners;
        synchronized (multimap) {
            typeListeners = new ArrayList(this.listeners.get((Object)type));
        }
        for (RemoteObjectEventListener eventListener : typeListeners) {
            try {
                eventListener.onEvent(type, data);
            }
            catch (Exception e) {
                LOG.error("Exception executing event listener", (Throwable)e);
            }
        }
    }

    public Transaction beginTransaction() {
        return new TransactionImpl(this.manager);
    }

    private void checkCreated() {
        if (this.objectStatus == ObjectStatus.NOT_COMMITED) {
            throw new TransactionNotCommitedException();
        }
        if (this.objectStatus == ObjectStatus.ROLLBACK) {
            throw new TransactionRollbackException((Throwable)((Object)this.transactionException));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.objectRef == null ? 0 : this.objectRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteObject other = (RemoteObject)obj;
        return !(this.objectRef == null ? other.objectRef != null : !this.objectRef.equals(other.objectRef));
    }

    public void setCreatedObjectRef(String objectRef) {
        this.objectRef = objectRef;
        this.objectStatus = ObjectStatus.CREATED;
        this.createReadyLatchIfNecessary();
        this.readyLatch.countDown();
        if (this.whenContinuation != null) {
            this.execWhenCommited();
        }
    }

    public void rollbackTransaction(TransactionExecutionException transactionException) {
        this.objectStatus = ObjectStatus.ROLLBACK;
        this.transactionException = transactionException;
    }

    public static enum ObjectStatus {
        NOT_COMMITED,
        ROLLBACK,
        CREATED;

    }
}

