/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.client;

import org.kurento.client.Continuation;
import org.kurento.client.internal.client.RemoteObject;
import org.kurento.client.internal.client.RomClient;
import org.kurento.client.internal.client.RomManager;
import org.kurento.jsonrpc.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(RemoteObjectFactory.class);
    private final RomClient client;
    private final RomManager manager;

    public RemoteObjectFactory(RomClient client) {
        this.client = client;
        this.manager = new RomManager(client);
    }

    public RemoteObject create(String remoteClassName, Props constructorParams) {
        String objectRef = this.client.create(remoteClassName, constructorParams);
        return new RemoteObject(objectRef, remoteClassName, this.manager);
    }

    public RemoteObject create(String remoteClassName) {
        return this.create(remoteClassName, (Props)null);
    }

    public void create(final String remoteClassName, Props constructorParams, final Continuation<RemoteObject> cont) {
        this.client.create(remoteClassName, constructorParams, new Continuation<String>(){

            @Override
            public void onSuccess(String objectRef) {
                try {
                    cont.onSuccess(new RemoteObject(objectRef, remoteClassName, RemoteObjectFactory.this.manager));
                }
                catch (Exception e) {
                    log.warn("[Continuation] error invoking onSuccess implemented by client", (Throwable)e);
                }
            }

            @Override
            public void onError(Throwable cause) {
                try {
                    cont.onError(cause);
                }
                catch (Exception e) {
                    log.warn("[Continuation] error invoking onError implemented by client", (Throwable)e);
                }
            }
        });
    }

    public void create(String remoteClassName, Continuation<RemoteObject> cont) {
        this.create(remoteClassName, null, cont);
    }

    public void destroy() {
        this.client.destroy();
    }

    public RomManager getManager() {
        return this.manager;
    }
}

