/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.transport.serialization;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.kurento.client.internal.server.ProtocolException;

public class ModuleClassesManager {
    private final ConcurrentHashMap<String, String> packageNamesByModuleName = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<?>> classesByClassName = new ConcurrentHashMap();

    public Class<?> getClassFor(String fullyTypeName) {
        String[] parts = fullyTypeName.split("\\.");
        return this.getClassFor(parts[0], parts[1]);
    }

    public Class<?> getClassFor(String moduleName, String typeName) {
        Objects.requireNonNull(typeName, "typeName must not be null");
        Objects.requireNonNull(moduleName, "moduleName must not be null");
        try {
            String className;
            Class<?> clazz;
            String packageName = this.packageNamesByModuleName.get(moduleName);
            if (packageName == null) {
                packageName = this.getPackageNameWithModuleInfoClass(moduleName);
                this.packageNamesByModuleName.put(moduleName, packageName);
            }
            if ((clazz = this.classesByClassName.get(className = packageName + "." + typeName)) == null) {
                clazz = Class.forName(className);
                this.classesByClassName.put(className, clazz);
            }
            return clazz;
        }
        catch (Exception e) {
            throw new ProtocolException("Exception creating Java Class for '" + moduleName + "." + typeName + "'", e);
        }
    }

    private String getPackageNameWithModuleInfoClass(String moduleName) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String moduleInfoClassName = this.getModuleInfoClassName(moduleName);
        Class<?> clazzPackage = Class.forName(moduleInfoClassName);
        Method method = clazzPackage.getMethod("getPackageName", new Class[0]);
        return (String)method.invoke(clazzPackage, new Object[0]);
    }

    private String getModuleInfoClassName(String moduleName) {
        String moduleNameWithFirstUpper = moduleName.substring(0, 1).toUpperCase() + moduleName.substring(1, moduleName.length());
        String classPackageName = "org.kurento.module." + moduleNameWithFirstUpper + "ModuleInfo";
        return classPackageName;
    }
}

