/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.BeanShellTestElement;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterException;
import org.apache.log.Logger;

public class BeanShellListener
extends BeanShellTestElement
implements Cloneable,
SampleListener,
TestBean,
Visualizer,
UnsharedComponent {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 4L;
    private static final String INIT_FILE = "beanshell.listener.init";

    protected String getInitFileProperty() {
        return INIT_FILE;
    }

    public void sampleOccurred(SampleEvent se) {
        BeanShellInterpreter bshInterpreter = this.getBeanShellInterpreter();
        if (bshInterpreter == null) {
            log.error("BeanShell not found");
            return;
        }
        SampleResult samp = se.getResult();
        try {
            bshInterpreter.set("sampleEvent", (Object)se);
            bshInterpreter.set("sampleResult", (Object)samp);
            this.processFileOrScript(bshInterpreter);
        }
        catch (JMeterException e) {
            log.warn("Problem in BeanShell script " + (Object)((Object)e));
        }
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public void add(SampleResult sample) {
    }

    public boolean isStats() {
        return false;
    }
}

