/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.selenium.Platform;

public class DefaultCapabilityMatcher
implements CapabilityMatcher {
    private static final Logger log = Logger.getLogger(DefaultCapabilityMatcher.class.getName());
    private static final String GRID_TOKEN = "_";
    private final List<String> toConsider = new ArrayList<String>();

    public DefaultCapabilityMatcher() {
        this.toConsider.add("platform");
        this.toConsider.add("browserName");
        this.toConsider.add("version");
        this.toConsider.add("applicationName");
    }

    @Override
    public boolean matches(Map<String, Object> nodeCapability, Map<String, Object> requestedCapability) {
        if (nodeCapability == null || requestedCapability == null) {
            return false;
        }
        for (String key : requestedCapability.keySet()) {
            String value;
            if (key.startsWith(GRID_TOKEN) || !this.toConsider.contains(key) || requestedCapability.get(key) == null || "ANY".equalsIgnoreCase(value = requestedCapability.get(key).toString()) || "".equals(value) || "*".equals(value)) continue;
            Platform requested = this.extractPlatform(requestedCapability.get(key));
            if (requested != null) {
                Platform node = this.extractPlatform(nodeCapability.get(key));
                if (node == null) {
                    return false;
                }
                if (node.is(requested)) continue;
                return false;
            }
            if (requestedCapability.get(key).equals(nodeCapability.get(key))) continue;
            return false;
        }
        return true;
    }

    Platform extractPlatform(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Platform) {
            return (Platform)o;
        }
        if (o instanceof String) {
            String name = o.toString();
            try {
                return Platform.valueOf((String)name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                for (Platform os : Platform.values()) {
                    for (String matcher : os.getPartOfOsName()) {
                        if ("".equals(matcher) || !name.equalsIgnoreCase(matcher)) continue;
                        return os;
                    }
                }
                return null;
            }
        }
        return null;
    }
}

