/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web;

import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.utils.GridHubConfiguration;
import org.openqa.grid.web.servlet.ConsoleServlet;
import org.openqa.grid.web.servlet.DisplayHelpServlet;
import org.openqa.grid.web.servlet.DriverServlet;
import org.openqa.grid.web.servlet.Grid1HeartbeatServlet;
import org.openqa.grid.web.servlet.HubStatusServlet;
import org.openqa.grid.web.servlet.LifecycleServlet;
import org.openqa.grid.web.servlet.ProxyStatusServlet;
import org.openqa.grid.web.servlet.RegistrationServlet;
import org.openqa.grid.web.servlet.ResourceServlet;
import org.openqa.grid.web.servlet.TestSessionStatusServlet;
import org.openqa.grid.web.utils.ExtraServletUtil;
import org.openqa.selenium.net.NetworkUtils;
import org.seleniumhq.jetty9.server.ConnectionFactory;
import org.seleniumhq.jetty9.server.Connector;
import org.seleniumhq.jetty9.server.Handler;
import org.seleniumhq.jetty9.server.HttpConfiguration;
import org.seleniumhq.jetty9.server.HttpConnectionFactory;
import org.seleniumhq.jetty9.server.Server;
import org.seleniumhq.jetty9.server.ServerConnector;
import org.seleniumhq.jetty9.servlet.ServletContextHandler;
import org.seleniumhq.jetty9.util.thread.QueuedThreadPool;
import org.seleniumhq.jetty9.util.thread.ThreadPool;

public class Hub {
    private static final Logger log = Logger.getLogger(Hub.class.getName());
    private final int port;
    private final String host;
    private final int maxThread;
    private final boolean isHostRestricted;
    private final Registry registry;
    private final Map<String, Class<? extends Servlet>> extraServlet = Maps.newHashMap();
    private Server server;

    private void addServlet(String key, Class<? extends Servlet> s) {
        this.extraServlet.put(key, s);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Hub(GridHubConfiguration config) {
        this.registry = Registry.newInstance(this, config);
        this.maxThread = config.getJettyMaxThreads();
        if (config.getHost() != null) {
            this.host = config.getHost();
            this.isHostRestricted = true;
        } else {
            NetworkUtils utils = new NetworkUtils();
            this.host = utils.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
            this.isHostRestricted = false;
        }
        this.port = config.getPort();
        for (String s : config.getServlets()) {
            Class<? extends Servlet> servletClass = ExtraServletUtil.createServlet(s);
            if (servletClass == null) continue;
            String path = "/grid/admin/" + servletClass.getSimpleName() + "/*";
            log.info("binding " + servletClass.getCanonicalName() + " to " + path);
            this.addServlet(path, servletClass);
        }
        this.initServer();
    }

    private void initServer() {
        try {
            if (this.maxThread > 0) {
                QueuedThreadPool pool = new QueuedThreadPool();
                pool.setMaxThreads(this.maxThread);
                this.server = new Server((ThreadPool)pool);
            } else {
                this.server = new Server();
            }
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(this.getPort());
            log.info("Will listen on " + this.port);
            ServerConnector http = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            http.setPort(this.port);
            this.server.addConnector((Connector)http);
            ServletContextHandler root = new ServletContextHandler(1);
            root.setContextPath("/");
            this.server.setHandler((Handler)root);
            root.setAttribute(Registry.KEY, (Object)this.registry);
            root.addServlet(DisplayHelpServlet.class.getName(), "/*");
            root.addServlet(org.openqa.grid.web.servlet.beta.ConsoleServlet.class.getName(), "/grid/console/*");
            root.addServlet(org.openqa.grid.web.servlet.beta.ConsoleServlet.class.getName(), "/grid/beta/console/*");
            root.addServlet(ConsoleServlet.class.getName(), "/grid/old/console/*");
            root.addServlet(RegistrationServlet.class.getName(), "/grid/register/*");
            root.addServlet(DriverServlet.class.getName(), "/grid/driver/*");
            root.addServlet(DriverServlet.class.getName(), "/wd/hub/*");
            root.addServlet(DriverServlet.class.getName(), "/selenium-server/driver/*");
            root.addServlet(ResourceServlet.class.getName(), "/grid/resources/*");
            root.addServlet(ProxyStatusServlet.class.getName(), "/grid/api/proxy/*");
            root.addServlet(HubStatusServlet.class.getName(), "/grid/api/hub/*");
            root.addServlet(TestSessionStatusServlet.class.getName(), "/grid/api/testsession/*");
            root.addServlet(LifecycleServlet.class.getName(), "/lifecycle-manager/*");
            root.addServlet(RegistrationServlet.class.getName(), "/registration-manager/register/*");
            root.addServlet(Grid1HeartbeatServlet.class.getName(), "/heartbeat");
            for (Map.Entry<String, Class<? extends Servlet>> entry : this.extraServlet.entrySet()) {
                root.addServlet(entry.getValue().getName(), entry.getKey());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error initializing the hub" + e.getMessage(), e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void start() throws Exception {
        this.initServer();
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public URL getUrl() {
        try {
            return new URL("http://" + this.getHost() + ":" + this.getPort());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public URL getRegistrationURL() {
        String uri = "http://" + this.getHost() + ":" + this.getPort() + "/grid/register/";
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

