/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.web.servlet.RegistryBasedServlet;

public class HubStatusServlet
extends RegistryBasedServlet {
    public HubStatusServlet() {
        super(null);
    }

    public HubStatusServlet(Registry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        try {
            JsonObject res = this.getResponse(request);
            response.getWriter().print(res);
            response.getWriter().close();
        }
        catch (JsonSyntaxException e) {
            throw new GridException(e.getMessage());
        }
    }

    private JsonObject getResponse(HttpServletRequest request) throws IOException {
        JsonObject res = new JsonObject();
        res.addProperty("success", Boolean.valueOf(true));
        try {
            if (request.getInputStream() != null) {
                Set<String> paramsToReturn;
                JsonObject requestJSON = this.getRequestJSON(request);
                JsonArray keys = requestJSON != null ? requestJSON.get("configuration").getAsJsonArray() : null;
                Registry registry = this.getRegistry();
                Map<String, Object> allParams = registry.getConfiguration().getAllParams();
                if (requestJSON == null || keys.size() == 0) {
                    paramsToReturn = allParams.keySet();
                } else {
                    paramsToReturn = new HashSet<String>();
                    for (int i = 0; i < keys.size(); ++i) {
                        paramsToReturn.add(keys.get(i).getAsString());
                    }
                }
                if (paramsToReturn.contains("newSessionRequestCount")) {
                    res.addProperty("newSessionRequestCount", (Number)registry.getNewSessionRequestCount());
                    paramsToReturn.remove("newSessionRequestCount");
                }
                if (paramsToReturn.contains("slotCounts")) {
                    res.add("slotCounts", (JsonElement)this.getSlotCounts());
                    paramsToReturn.remove("slotCounts");
                }
                for (String key : paramsToReturn) {
                    Object value = allParams.get(key);
                    if (value == null) {
                        res.add(key, (JsonElement)JsonNull.INSTANCE);
                        continue;
                    }
                    res.add(key, new Gson().toJsonTree(value));
                }
            }
        }
        catch (Exception e) {
            res.remove("success");
            res.addProperty("success", Boolean.valueOf(false));
            res.addProperty("msg", e.getMessage());
        }
        return res;
    }

    private JsonObject getSlotCounts() {
        int freeSlots = 0;
        int totalSlots = 0;
        for (RemoteProxy proxy : this.getRegistry().getAllProxies()) {
            for (TestSlot slot : proxy.getTestSlots()) {
                if (slot.getSession() == null) {
                    ++freeSlots;
                }
                ++totalSlots;
            }
        }
        JsonObject result = new JsonObject();
        result.addProperty("free", (Number)freeSlots);
        result.addProperty("total", (Number)totalSlots);
        return result;
    }

    private JsonObject getRequestJSON(HttpServletRequest request) throws IOException {
        String line;
        JsonObject requestJSON = null;
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        StringBuilder s = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            s.append(line);
        }
        rd.close();
        String json = s.toString();
        if (!"".equals(json)) {
            requestJSON = new JsonParser().parse(json).getAsJsonObject();
        }
        return requestJSON;
    }
}

