/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.ConvertBean;
import jodd.typeconverter.TypeConverter;
import jodd.util.CsvUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerArrayConverter
implements TypeConverter<int[]> {
    protected final ConvertBean convertBean;

    public IntegerArrayConverter(ConvertBean convertBean) {
        this.convertBean = convertBean;
    }

    @Override
    public int[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (type == String.class) {
                Object[] values = CsvUtil.toStringArray(value.toString());
                return this.convertArray(values);
            }
            return new int[]{this.convertBean.toIntValue(value)};
        }
        if (type.getComponentType().isPrimitive()) {
            if (type == int[].class) {
                return (int[])value;
            }
            if (type == long[].class) {
                long[] values = (long[])value;
                int[] results = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (int)values[i];
                }
                return results;
            }
            if (type == double[].class) {
                double[] values = (double[])value;
                int[] results = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (int)values[i];
                }
                return results;
            }
            if (type == byte[].class) {
                byte[] values = (byte[])value;
                int[] results = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == float[].class) {
                float[] values = (float[])value;
                int[] results = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (int)values[i];
                }
                return results;
            }
            if (type == boolean[].class) {
                boolean[] values = (boolean[])value;
                int[] results = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i] ? 1 : 0;
                }
                return results;
            }
            if (type == short[].class) {
                short[] values = (short[])value;
                int[] results = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
        }
        return this.convertArray((Object[])value);
    }

    protected int[] convertArray(Object[] values) {
        int[] results = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            results[i] = this.convertBean.toIntValue(values[i]);
        }
        return results;
    }
}

