/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoOptions;
import javax.net.ssl.SSLSocketFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.data.mongodb.core.ReflectiveMongoOptionsInvoker;
import org.springframework.data.mongodb.util.MongoClientVersion;

@Deprecated
public class MongoOptionsFactoryBean
extends AbstractFactoryBean<MongoOptions> {
    private static final MongoOptions DEFAULT_MONGO_OPTIONS = new MongoOptions();
    private int connectionsPerHost = DEFAULT_MONGO_OPTIONS.getConnectionsPerHost();
    private int threadsAllowedToBlockForConnectionMultiplier = DEFAULT_MONGO_OPTIONS.getThreadsAllowedToBlockForConnectionMultiplier();
    private int maxWaitTime = DEFAULT_MONGO_OPTIONS.getMaxWaitTime();
    private int connectTimeout = DEFAULT_MONGO_OPTIONS.getConnectTimeout();
    private int socketTimeout = DEFAULT_MONGO_OPTIONS.getSocketTimeout();
    private boolean socketKeepAlive = DEFAULT_MONGO_OPTIONS.isSocketKeepAlive();
    private int writeNumber = DEFAULT_MONGO_OPTIONS.getW();
    private int writeTimeout = DEFAULT_MONGO_OPTIONS.getWtimeout();
    private boolean writeFsync = DEFAULT_MONGO_OPTIONS.isFsync();
    private boolean autoConnectRetry = !MongoClientVersion.isMongo3Driver() ? ReflectiveMongoOptionsInvoker.getAutoConnectRetry(DEFAULT_MONGO_OPTIONS) : false;
    private long maxAutoConnectRetryTime = !MongoClientVersion.isMongo3Driver() ? ReflectiveMongoOptionsInvoker.getMaxAutoConnectRetryTime(DEFAULT_MONGO_OPTIONS) : -1L;
    private boolean slaveOk = !MongoClientVersion.isMongo3Driver() ? ReflectiveMongoOptionsInvoker.getSlaveOk(DEFAULT_MONGO_OPTIONS) : false;
    private boolean ssl;
    private SSLSocketFactory sslSocketFactory;

    public void setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
    }

    public void setThreadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
        this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public void setWriteNumber(int writeNumber) {
        this.writeNumber = writeNumber;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setWriteFsync(boolean writeFsync) {
        this.writeFsync = writeFsync;
    }

    @Deprecated
    public void setAutoConnectRetry(boolean autoConnectRetry) {
        this.autoConnectRetry = autoConnectRetry;
    }

    @Deprecated
    public void setMaxAutoConnectRetryTime(long maxAutoConnectRetryTime) {
        this.maxAutoConnectRetryTime = maxAutoConnectRetryTime;
    }

    @Deprecated
    public void setSlaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.setSsl(sslSocketFactory != null);
        this.sslSocketFactory = sslSocketFactory;
    }

    protected MongoOptions createInstance() throws Exception {
        if (MongoClientVersion.isMongo3Driver()) {
            throw new IllegalArgumentException(String.format("Usage of 'mongo-options' is no longer supported for MongoDB Java driver version 3 and above. Please use 'mongo-client-options' and refer to chapter 'MongoDB 3.0 Support' for details.", new Object[0]));
        }
        MongoOptions options = new MongoOptions();
        options.setConnectionsPerHost(this.connectionsPerHost);
        options.setThreadsAllowedToBlockForConnectionMultiplier(this.threadsAllowedToBlockForConnectionMultiplier);
        options.setMaxWaitTime(this.maxWaitTime);
        options.setConnectTimeout(this.connectTimeout);
        options.setSocketTimeout(this.socketTimeout);
        options.setSocketKeepAlive(this.socketKeepAlive);
        options.setW(this.writeNumber);
        options.setWtimeout(this.writeTimeout);
        options.setFsync(this.writeFsync);
        if (this.ssl) {
            options.setSocketFactory(this.sslSocketFactory != null ? this.sslSocketFactory : SSLSocketFactory.getDefault());
        }
        ReflectiveMongoOptionsInvoker.setAutoConnectRetry(options, this.autoConnectRetry);
        ReflectiveMongoOptionsInvoker.setMaxAutoConnectRetryTime(options, this.maxAutoConnectRetryTime);
        ReflectiveMongoOptionsInvoker.setSlaveOk(options, this.slaveOk);
        return options;
    }

    public Class<?> getObjectType() {
        return MongoOptions.class;
    }
}

