/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.util.Assert;

public enum AggregationFunctionExpressions {
    SIZE;


    public AggregationExpression of(Object ... parameters) {
        Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
        return new FunctionExpression(this.name().toLowerCase(), parameters);
    }

    static class FunctionExpression
    implements AggregationExpression {
        private final String name;
        private final Object[] values;

        public FunctionExpression(String name, Object[] values) {
            Assert.hasText((String)name, (String)"Name must not be null!");
            Assert.notNull((Object)values, (String)"Values must not be null!");
            this.name = name;
            this.values = values;
        }

        @Override
        public DBObject toDbObject(AggregationOperationContext context) {
            ArrayList<Object> args = new ArrayList<Object>(this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                args.add(FunctionExpression.unpack(this.values[i], context));
            }
            return new BasicDBObject("$" + this.name, args);
        }

        private static Object unpack(Object value, AggregationOperationContext context) {
            if (value instanceof AggregationExpression) {
                return ((AggregationExpression)value).toDbObject(context);
            }
            if (value instanceof Field) {
                return context.getReference((Field)value).toString();
            }
            return value;
        }
    }
}

