/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.SimpleTypeInformationMapper;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

public class DefaultMongoTypeMapper
extends DefaultTypeMapper<DBObject>
implements MongoTypeMapper {
    public static final String DEFAULT_TYPE_KEY = "_class";
    private static final TypeInformation<List> LIST_TYPE_INFO = ClassTypeInformation.from(List.class);
    private static final TypeInformation<Map> MAP_TYPE_INFO = ClassTypeInformation.from(Map.class);
    private final TypeAliasAccessor<DBObject> accessor;
    private final String typeKey;

    public DefaultMongoTypeMapper() {
        this(DEFAULT_TYPE_KEY);
    }

    public DefaultMongoTypeMapper(String typeKey) {
        this(typeKey, Arrays.asList(SimpleTypeInformationMapper.INSTANCE));
    }

    public DefaultMongoTypeMapper(String typeKey, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext) {
        this(typeKey, new DBObjectTypeAliasAccessor(typeKey), mappingContext, Arrays.asList(SimpleTypeInformationMapper.INSTANCE));
    }

    public DefaultMongoTypeMapper(String typeKey, List<? extends TypeInformationMapper> mappers) {
        this(typeKey, new DBObjectTypeAliasAccessor(typeKey), null, mappers);
    }

    private DefaultMongoTypeMapper(String typeKey, TypeAliasAccessor<DBObject> accessor, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext, List<? extends TypeInformationMapper> mappers) {
        super(accessor, mappingContext, mappers);
        this.typeKey = typeKey;
        this.accessor = accessor;
    }

    @Override
    public boolean isTypeKey(String key) {
        return this.typeKey == null ? false : this.typeKey.equals(key);
    }

    @Override
    public void writeTypeRestrictions(DBObject result, Set<Class<?>> restrictedTypes) {
        if (restrictedTypes == null || restrictedTypes.isEmpty()) {
            return;
        }
        BasicDBList restrictedMappedTypes = new BasicDBList();
        for (Class<?> restrictedType : restrictedTypes) {
            Object typeAlias = this.getAliasFor((TypeInformation)ClassTypeInformation.from(restrictedType));
            if (typeAlias == null) continue;
            restrictedMappedTypes.add(typeAlias);
        }
        this.accessor.writeTypeTo((Object)result, (Object)new BasicDBObject("$in", (Object)restrictedMappedTypes));
    }

    protected TypeInformation<?> getFallbackTypeFor(DBObject source) {
        return source instanceof BasicDBList ? LIST_TYPE_INFO : MAP_TYPE_INFO;
    }

    public static final class DBObjectTypeAliasAccessor
    implements TypeAliasAccessor<DBObject> {
        private final String typeKey;

        public DBObjectTypeAliasAccessor(String typeKey) {
            this.typeKey = typeKey;
        }

        public Object readAliasFrom(DBObject source) {
            if (source instanceof BasicDBList) {
                return null;
            }
            return source.get(this.typeKey);
        }

        public void writeTypeTo(DBObject sink, Object alias) {
            if (this.typeKey != null) {
                sink.put(this.typeKey, alias);
            }
        }
    }
}

