/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.util.WebUtils;

public class OriginHandshakeInterceptor
implements HandshakeInterceptor {
    protected Log logger = LogFactory.getLog(this.getClass());
    private final List<String> allowedOrigins = new ArrayList<String>();

    public OriginHandshakeInterceptor() {
    }

    public OriginHandshakeInterceptor(Collection<String> allowedOrigins) {
        this();
        this.setAllowedOrigins(allowedOrigins);
    }

    public void setAllowedOrigins(Collection<String> allowedOrigins) {
        Assert.notNull(allowedOrigins, (String)"Allowed origin Collection must not be null");
        this.allowedOrigins.clear();
        this.allowedOrigins.addAll(allowedOrigins);
    }

    public Collection<String> getAllowedOrigins() {
        return Collections.unmodifiableList(this.allowedOrigins);
    }

    @Override
    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
        if (!WebUtils.isSameOrigin((HttpRequest)request) && !WebUtils.isValidOrigin((HttpRequest)request, this.allowedOrigins)) {
            response.setStatusCode(HttpStatus.FORBIDDEN);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Handshake request rejected, Origin header value " + request.getHeaders().getOrigin() + " not allowed"));
            }
            return false;
        }
        return true;
    }

    @Override
    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
    }
}

