/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.junit.After;
import org.junit.Before;
import org.kurento.client.KurentoClient;
import org.kurento.client.MediaPipeline;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.test.base.BrowserTest;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.WebPage;
import org.kurento.test.lifecycle.FailedTest;
import org.kurento.test.monitor.SystemMonitorManager;
import org.kurento.test.services.FakeKmsService;
import org.kurento.test.services.KmsService;
import org.kurento.test.services.Service;
import org.kurento.test.services.WebServerService;
import org.kurento.test.utils.WebRtcConnector;

public class KurentoClientBrowserTest<W extends WebPage>
extends BrowserTest<W> {
    @Service
    public static WebServerService webServer = new WebServerService();
    @Service
    public static KmsService kms = new KmsService();
    @Service
    public static FakeKmsService fakeKms = new FakeKmsService();
    protected static KurentoClient kurentoClient;
    protected static KurentoClient fakeKurentoClient;

    @Before
    public void setupKurentoClient() {
        kurentoClient = kms.getKurentoClient();
    }

    @After
    public void teardownKurentoClient() throws Exception {
        kms.closeKurentoClient();
    }

    @FailedTest
    public static void retrieveGstreamerDots() {
        if (kurentoClient != null) {
            try {
                List pipelines = kurentoClient.getServerManager().getPipelines();
                log.debug("Retrieving GStreamerDots for all pipelines in KMS ({})", (Object)pipelines.size());
                for (MediaPipeline pipeline : pipelines) {
                    String pipelineName = pipeline.getName();
                    log.debug("Saving GstreamerDot for pipeline {}", (Object)pipelineName);
                    String gstreamerDotFile = KurentoTest.getDefaultOutputFile("-" + pipelineName);
                    try {
                        FileUtils.writeStringToFile((File)new File(gstreamerDotFile), (String)pipeline.getGstreamerDot());
                    }
                    catch (IOException ioe) {
                        log.error("Exception writing GstreamerDot file", (Throwable)ioe);
                    }
                }
            }
            catch (WebSocketException e) {
                log.warn("WebSocket exception while reading existing pipelines. Maybe KMS is closed: {}:{}", (Object)((Object)((Object)e)).getClass().getName(), (Object)e.getMessage());
            }
        }
    }

    protected String getDefaultFileForRecording() {
        return KurentoClientBrowserTest.getDefaultOutputFile(".webm");
    }

    public void addFakeClients(int numFakeClients, int bandwidht, MediaPipeline mainPipeline, WebRtcEndpoint senderWebRtcEndpoint) {
        fakeKms.addFakeClients(numFakeClients, bandwidht, mainPipeline, senderWebRtcEndpoint, 0L, null, null);
    }

    public void addFakeClients(int numFakeClients, MediaPipeline mainPipeline, WebRtcEndpoint senderWebRtcEndpoint, long timeBetweenClientMs, SystemMonitorManager monitor, WebRtcConnector connector) {
        fakeKms.addFakeClients(numFakeClients, -1, mainPipeline, senderWebRtcEndpoint, timeBetweenClientMs, monitor, connector);
    }
}

