/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import java.awt.Color;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.kurento.client.EndOfStreamEvent;
import org.kurento.client.EventListener;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.PlayerEndpoint;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.commons.testing.SystemStabilityTests;
import org.kurento.test.base.KurentoClientBrowserTest;
import org.kurento.test.browser.WebRtcChannel;
import org.kurento.test.browser.WebRtcMode;
import org.kurento.test.browser.WebRtcTestPage;

@Category(value={SystemStabilityTests.class})
public class StabilityTest
extends KurentoClientBrowserTest<WebRtcTestPage> {
    public StabilityTest() {
        StabilityTest.setDeleteLogsIfSuccess(false);
    }

    public void testPlayerMultipleSeek(String mediaUrl, WebRtcChannel webRtcChannel, int pauseTimeSeconds, int numSeeks, Map<Integer, Color> expectedPositionAndColor) throws Exception {
        MediaPipeline mp = kurentoClient.createMediaPipeline();
        PlayerEndpoint playerEP = (PlayerEndpoint)new PlayerEndpoint.Builder(mp, mediaUrl).build();
        WebRtcEndpoint webRtcEP = (WebRtcEndpoint)new WebRtcEndpoint.Builder(mp).build();
        playerEP.connect((MediaElement)webRtcEP);
        final CountDownLatch eosLatch = new CountDownLatch(1);
        playerEP.addEndOfStreamListener((EventListener)new EventListener<EndOfStreamEvent>(){

            public void onEvent(EndOfStreamEvent event) {
                eosLatch.countDown();
            }
        });
        ((WebRtcTestPage)this.getPage()).subscribeEvents("playing");
        ((WebRtcTestPage)this.getPage()).initWebRtc(webRtcEP, webRtcChannel, WebRtcMode.RCV_ONLY);
        playerEP.play();
        Thread.sleep(TimeUnit.SECONDS.toMillis(pauseTimeSeconds));
        for (int i = 0; i < numSeeks; ++i) {
            for (Integer position : expectedPositionAndColor.keySet()) {
                playerEP.setPosition((long)position.intValue());
                if (webRtcChannel != WebRtcChannel.AUDIO_ONLY) {
                    Assert.assertTrue((String)("After set position to " + position + "ms, the color of the video should be " + expectedPositionAndColor.get(position)), (boolean)((WebRtcTestPage)this.getPage()).similarColor(expectedPositionAndColor.get(position)));
                }
                playerEP.setPosition(0L);
            }
        }
        Assert.assertTrue((String)("Not received media (timeout waiting playing event): " + mediaUrl + " " + (Object)((Object)webRtcChannel)), (boolean)((WebRtcTestPage)this.getPage()).waitForEvent("playing"));
        Assert.assertTrue((String)("Not received EOS event in player: " + mediaUrl + " " + (Object)((Object)webRtcChannel)), (boolean)eosLatch.await(((WebRtcTestPage)this.getPage()).getTimeout(), TimeUnit.SECONDS));
        mp.release();
    }
}

