/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.internal;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.kurento.test.grid.GridHandler;
import org.kurento.test.utils.SshConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillAllProcesses {
    public static Logger log = LoggerFactory.getLogger(KillAllProcesses.class);

    public static void main(String[] args) throws InterruptedException {
        List<String> nodeList = GridHandler.getInstance().getNodeList();
        int nodeListSize = nodeList.size();
        log.debug("Node availables in the node list: {}", (Object)nodeListSize);
        ExecutorService executor = Executors.newFixedThreadPool(nodeListSize);
        final CountDownLatch latch = new CountDownLatch(nodeListSize);
        for (final String node : nodeList) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName(node);
                    if (SshConnection.ping(node)) {
                        SshConnection remoteHost = null;
                        try {
                            log.info("Openning connection to node {}", (Object)node);
                            remoteHost = new SshConnection(node);
                            remoteHost.start();
                            remoteHost.execCommand("kill", "-9", "-1");
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (remoteHost != null) {
                                log.info("Closing connection to node {}", (Object)node);
                                remoteHost.stop();
                            }
                        }
                    } else {
                        log.error("Node down {}", (Object)node);
                    }
                    latch.countDown();
                }
            });
        }
        latch.await();
        executor.shutdown();
    }
}

