/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.google.common.io.CharStreams;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.commons.io.FileUtils;
import org.kurento.client.ErrorEvent;
import org.kurento.client.EventListener;
import org.kurento.client.KurentoClient;
import org.kurento.client.MediaPipeline;
import org.kurento.client.ObjectCreatedEvent;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.docker.Docker;
import org.kurento.test.services.TestService;
import org.kurento.test.utils.Shell;
import org.kurento.test.utils.SshConnection;

public class KmsService
extends TestService {
    protected static String monitoredDockerContainerName;
    protected String dockerContainerName = "kms";
    protected SshConnection remoteKmsSshConnection;
    protected Path workspace;
    protected String wsUri;
    protected boolean isKmsRemote;
    protected boolean isKmsDocker;
    protected boolean isKmsStarted;
    protected String registrarUri;
    protected String registrarLocalAddress = "127.0.0.1";
    protected String kmsLoginProp;
    protected String kmsPasswdProp;
    protected String kmsPemProp;
    protected String kmsAutostartProp;
    protected String kmsAutostartDefault;
    protected String kmsWsUriProp;
    protected String kmsWsUriExportProp;
    protected String kmsScopeProp;
    protected String kmsScopeDefault;
    protected KurentoClient kurentoClient;

    public KmsService(String wsUri) {
        this();
        this.setWsUri(wsUri);
    }

    public KmsService() {
        this.kmsLoginProp = "kms.login";
        this.kmsPasswdProp = "kms.passwd";
        this.kmsPemProp = "kms.pem";
        this.kmsAutostartProp = "test.kms.autostart";
        this.kmsAutostartDefault = "test";
        this.kmsWsUriProp = "kms.ws.uri";
        this.kmsWsUriExportProp = "kms.url";
        this.kmsScopeProp = "test.kms.scope";
        this.kmsScopeDefault = "local";
        this.setWsUri(PropertiesManager.getProperty((String)this.kmsWsUriProp, (String)"ws://localhost:8888/kurento"));
    }

    public KmsService(String kmsLoginProp, String kmsPasswdProp, String kmsPemProp, String kmsAutostartProp, String kmsWsUriProp, String kmsWsUriExportProp, String kmsScopeProp, String kmsScopeDefault) {
        this.kmsLoginProp = kmsLoginProp;
        this.kmsPasswdProp = kmsPasswdProp;
        this.kmsPemProp = kmsPemProp;
        this.kmsAutostartProp = kmsAutostartProp;
        this.kmsWsUriProp = kmsWsUriProp;
        this.kmsWsUriExportProp = kmsWsUriExportProp;
        this.kmsScopeProp = kmsScopeProp;
        this.kmsScopeDefault = kmsScopeDefault;
        this.setWsUri(PropertiesManager.getProperty((String)kmsWsUriProp, (String)"ws://localhost:8888/kurento"));
    }

    @Override
    public void start() {
        super.start();
        if (this.wsUri == null) {
            log.warn("WS URI is null, will not start");
            this.isKmsStarted = false;
            return;
        }
        this.isKmsRemote = !this.wsUri.contains("localhost") && !this.wsUri.contains("127.0.0.1") && !this.isKmsDocker;
        this.isKmsDocker = "docker".equals(PropertiesManager.getProperty((String)this.kmsScopeProp, (String)this.kmsScopeDefault));
        String kmsLogin = PropertiesManager.getProperty((String)this.kmsLoginProp);
        String kmsPasswd = PropertiesManager.getProperty((String)this.kmsPasswdProp);
        String kmsPem = PropertiesManager.getProperty((String)this.kmsPemProp);
        String kmsAutoStart = PropertiesManager.getProperty((String)this.kmsAutostartProp, (String)this.kmsAutostartDefault);
        if (this.isKmsRemote && kmsLogin == null && (kmsPem == null || kmsPasswd == null)) {
            throw new KurentoException("Bad test parameters: " + this.kmsAutostartProp + "=" + kmsAutoStart + " and " + this.kmsWsUriProp + "=" + this.wsUri + ". Remote KMS should be started but its credentials are not present: " + this.kmsLoginProp + "=" + kmsLogin + ", " + this.kmsPasswdProp + "=" + kmsPasswd + ", " + this.kmsPemProp + "=" + kmsPem);
        }
        if (!(this.isKmsDocker || this.isKmsRemote || this.isFreePort(this.wsUri))) {
            throw new KurentoException("KMS cannot be started in URI: " + this.wsUri + ". Port is not free");
        }
        if (this.isKmsDocker) {
            log.info("Starting KMS dockerized");
            Docker dockerClient = Docker.getSingleton();
            if (dockerClient.isRunningInContainer()) {
                this.setDockerContainerName(dockerClient.getContainerName() + this.getDockerContainerNameSuffix());
            }
        } else {
            log.info("Starting KMS with URI: {}", (Object)this.wsUri);
            try {
                this.workspace = Files.createTempDirectory("kurento-test", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new KurentoException("Exception creating temporal folder", (Throwable)e);
            }
            log.trace("Local folder to store temporal files: {}", (Object)this.workspace);
            if (this.isKmsRemote) {
                String remoteKmsStr = this.wsUri.substring(this.wsUri.indexOf("//") + 2, this.wsUri.lastIndexOf(":"));
                log.info("Using remote KMS at {}", (Object)remoteKmsStr);
                this.remoteKmsSshConnection = new SshConnection(remoteKmsStr, kmsLogin, kmsPasswd, kmsPem);
                if (kmsPem != null) {
                    this.remoteKmsSshConnection.setPem(kmsPem);
                }
                this.remoteKmsSshConnection.start();
                this.remoteKmsSshConnection.createTmpFolder();
            }
            this.createKurentoConf();
        }
        if (this.isKmsRemote && !kmsAutoStart.equals("false")) {
            String[] filesToBeCopied;
            for (String s : filesToBeCopied = new String[]{"kurento.conf.json", "kurento.sh"}) {
                this.remoteKmsSshConnection.scp(this.workspace + File.separator + s, this.remoteKmsSshConnection.getTmpFolder() + File.separator + s);
            }
            this.remoteKmsSshConnection.runAndWaitCommand("chmod", "+x", this.remoteKmsSshConnection.getTmpFolder() + File.separator + "kurento.sh");
        }
        this.startKms();
        this.waitForKms();
    }

    @Override
    public void stop() {
        super.stop();
        this.closeKurentoClient();
        this.stopKms();
        try {
            this.retrieveLogs();
        }
        catch (IOException e) {
            log.warn("Exception retrieving KMS logs", (Throwable)e);
        }
        if (this.isKmsDocker) {
            Docker.getSingleton().removeContainer(this.dockerContainerName);
        }
        if (!this.isKmsDocker) {
            try {
                this.deleteFolderAndContent(this.workspace);
            }
            catch (IOException e) {
                log.warn("Exception deleting temporal folder {}", (Object)this.workspace, (Object)e);
            }
        }
    }

    @Override
    public TestService.TestServiceScope getScope() {
        String kmsAutostart;
        TestService.TestServiceScope scope = TestService.TestServiceScope.TESTSUITE;
        switch (kmsAutostart = PropertiesManager.getProperty((String)this.kmsAutostartProp, (String)this.kmsAutostartDefault)) {
            case "false": {
                scope = TestService.TestServiceScope.EXTERNAL;
                break;
            }
            case "test": {
                scope = TestService.TestServiceScope.TEST;
                break;
            }
            case "testclass": {
                scope = TestService.TestServiceScope.TESTCLASS;
                break;
            }
            case "testsuite": {
                scope = TestService.TestServiceScope.TESTSUITE;
            }
        }
        return scope;
    }

    protected String getDockerContainerNameSuffix() {
        return "_kms";
    }

    protected String getDockerLogSuffix() {
        return "-kms";
    }

    private boolean isFreePort(String wsUri) {
        try {
            URI wsUrl = new URI(wsUri);
            String result = Shell.runAndWait("/bin/bash", "-c", "nc -z " + wsUrl.getHost() + " " + wsUrl.getPort() + "; echo $?");
            if (result.trim().equals("0")) {
                log.warn("Port " + wsUrl.getPort() + " is used. Maybe another KMS instance is running in this port");
                return false;
            }
        }
        catch (URISyntaxException e) {
            log.warn("WebSocket URI {} is malformed: " + e.getMessage(), (Object)wsUri);
        }
        return true;
    }

    private void createKurentoConf() {
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            URI wsAsUri = new URI(this.wsUri);
            int port = wsAsUri.getPort();
            String path = wsAsUri.getPath();
            data.put("wsPort", String.valueOf(port));
            data.put("wsPath", path.substring(1));
            data.put("registrar", this.registrarUri);
            data.put("registrarLocalAddress", this.registrarLocalAddress);
        }
        catch (URISyntaxException e) {
            throw new KurentoException("Invalid ws uri: " + this.wsUri);
        }
        data.put("gstPlugins", this.getGstPlugins());
        data.put("debugOptions", this.getDebugOptions());
        data.put("serverCommand", this.getServerCommand());
        data.put("workspace", this.getKmsLogPath());
        cfg.setClassForTemplateLoading(this.getClass(), "/templates/");
        this.createFileFromTemplate(cfg, data, "kurento.conf.json");
        this.createFileFromTemplate(cfg, data, "kurento.sh");
        Shell.runAndWait("chmod", "+x", this.workspace + File.separator + "kurento.sh");
    }

    private void startKms() {
        String kmsLogPath = this.getKmsLogPath();
        if (this.isKmsRemote) {
            this.remoteKmsSshConnection.runAndWaitCommand("sh", "-c", kmsLogPath + "kurento.sh > /dev/null");
            log.info("Remote KMS started in URI {}", (Object)this.wsUri);
        } else if (this.isKmsDocker) {
            this.startDockerizedKms();
        } else {
            Shell.run("sh", "-c", kmsLogPath + "kurento.sh");
            log.info("Local KMS started in URI {}", (Object)this.wsUri);
        }
        this.isKmsStarted = true;
    }

    private void waitForKms() {
        long initTime = System.nanoTime();
        if (this.wsUri != null) {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            int NUM_RETRIES = 300;
            int WAIT_MILLIS = 100;
            for (int i = 0; i < NUM_RETRIES; ++i) {
                try {
                    @ClientEndpoint
                    class WebSocketClient
                    extends Endpoint {
                        WebSocketClient() {
                        }

                        @OnClose
                        public void onClose(Session session, CloseReason closeReason) {
                        }

                        @OnOpen
                        public void onOpen(Session session, EndpointConfig config) {
                        }
                    }
                    Session wsSession = container.connectToServer((Endpoint)new WebSocketClient(), ClientEndpointConfig.Builder.create().build(), new URI(this.wsUri));
                    wsSession.close();
                    double time = (double)(System.nanoTime() - initTime) / 1000000.0;
                    log.debug("Connected to KMS in " + String.format("%3.2f", time) + " milliseconds");
                    return;
                }
                catch (IOException | URISyntaxException | DeploymentException e) {
                    try {
                        Thread.sleep(WAIT_MILLIS);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
            }
            throw new KurentoException("Timeout of " + NUM_RETRIES * WAIT_MILLIS + " millis waiting for KMS " + this.wsUri);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.error("InterruptedException {}", (Object)e.getMessage());
        }
    }

    private void startDockerizedKms() {
        Docker dockerClient = Docker.getSingleton();
        String kmsImageName = PropertiesManager.getProperty((String)"test.kms.docker.image.name", (String)"kurento/kurento-media-server-dev:latest");
        boolean forcePulling = PropertiesManager.getProperty((String)"test.kms.docker.image.forcepulling", (boolean)true);
        if (!dockerClient.existsImage(kmsImageName) || forcePulling) {
            log.info("Pulling KMS image {} ... plase wait", (Object)kmsImageName);
            ((PullImageResultCallback)dockerClient.getClient().pullImageCmd(kmsImageName).exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
            log.info("KMS image {} pulled", (Object)kmsImageName);
        }
        if (dockerClient.existsContainer(this.dockerContainerName)) {
            log.warn("Trying to create a new container named '" + this.dockerContainerName + "' but it already exist. Stopping and removing existing one and creating it again.");
            dockerClient.stopAndRemoveContainer(this.dockerContainerName);
        }
        log.debug("Starting KMS container...");
        String s3BucketName = PropertiesManager.getProperty((String)"s3.bucket.name");
        String s3AccessKeyId = PropertiesManager.getProperty((String)"s3.access.key.id");
        String s3SecretAccessKey = PropertiesManager.getProperty((String)"s3.secret.access.key");
        String s3Hostname = PropertiesManager.getProperty((String)"s3.hostname");
        CreateContainerCmd createContainerCmd = dockerClient.getClient().createContainerCmd(kmsImageName).withName(this.dockerContainerName).withEnv(new String[]{"GST_DEBUG=" + this.getDebugOptions(), "S3_ACCESS_BUCKET_NAME=" + s3BucketName, "S3_ACCESS_KEY_ID=" + s3AccessKeyId, "S3_SECRET_ACCESS_KEY=" + s3SecretAccessKey, "S3_HOSTNAME=" + s3Hostname}).withCmd(new String[]{"--gst-debug-no-color"});
        if (dockerClient.isRunningInContainer()) {
            createContainerCmd.withVolumesFrom(new VolumesFrom[]{new VolumesFrom(dockerClient.getContainerId())});
        } else {
            String testFilesPath = KurentoTest.getTestFilesDiskPath();
            Volume volume = new Volume(testFilesPath);
            String targetPath = Paths.get(KurentoTest.getDefaultOutputFolder().toURI()).toAbsolutePath().toString();
            Volume volumeTest = new Volume(targetPath);
            createContainerCmd.withVolumes(new Volume[]{volume, volumeTest}).withBinds(new Bind[]{new Bind(testFilesPath, volume, AccessMode.ro), new Bind(targetPath, volumeTest, AccessMode.rw)});
        }
        CreateContainerResponse kmsContainer = createContainerCmd.exec();
        dockerClient.getClient().startContainerCmd(kmsContainer.getId()).exec();
        this.setWsUri("ws://" + dockerClient.inspectContainer(this.dockerContainerName).getNetworkSettings().getIpAddress() + ":8888/kurento");
        log.info("Dockerized KMS started in URI {}", (Object)this.wsUri);
    }

    public String getKmsLogPath() {
        String kmsAutoStart = PropertiesManager.getProperty((String)this.kmsAutostartProp, (String)this.kmsAutostartDefault);
        return kmsAutoStart.equals("false") ? PropertiesManager.getProperty((String)"kms.log.path", (String)"/var/log/kurento-media-server/") : (this.isKmsRemote ? this.remoteKmsSshConnection.getTmpFolder() + File.separator : this.workspace + File.separator);
    }

    private void createFileFromTemplate(Configuration cfg, Map<String, Object> data, String filename) {
        try {
            Template template = cfg.getTemplate(filename + ".ftl");
            File file = new File(this.workspace + File.separator + filename);
            FileWriter writer = new FileWriter(file);
            template.process(data, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            log.trace("Created file '{}'", (Object)file.getAbsolutePath());
        }
        catch (Exception e) {
            throw new KurentoException("Exception while creating file from template", (Throwable)e);
        }
    }

    public void retrieveLogs() throws IOException {
        File targetFolder = KurentoTest.getDefaultOutputFolder();
        String kmsLogsPath = this.getKmsLogPath();
        Path defaultOutput = Paths.get(targetFolder.toURI());
        if (!Files.exists(defaultOutput, new LinkOption[0])) {
            Files.createDirectories(defaultOutput, new FileAttribute[0]);
        }
        if (this.isKmsStarted) {
            kmsLogsPath = kmsLogsPath + "logs/";
        }
        String testMethodName = KurentoTest.getSimpleTestName();
        if (this.isKmsDocker) {
            Docker.getSingleton().downloadLog(this.dockerContainerName, Paths.get(targetFolder.getAbsolutePath(), testMethodName + this.getDockerLogSuffix() + ".log"));
        } else if (this.isKmsRemote) {
            if (!this.remoteKmsSshConnection.isStarted()) {
                this.remoteKmsSshConnection.start();
            }
            log.debug("Copying KMS logs located on {} from remote host {} to {}", new Object[]{kmsLogsPath, this.remoteKmsSshConnection.getConnection(), targetFolder});
            List<String> remoteLogFiles = this.remoteKmsSshConnection.listFiles(kmsLogsPath, true, false);
            for (String remoteLogFile : remoteLogFiles) {
                String localLogFile = targetFolder + "/" + testMethodName + "-" + remoteLogFile.substring(remoteLogFile.lastIndexOf("/") + 1);
                this.remoteKmsSshConnection.getFile(localLogFile, remoteLogFile);
                KurentoTest.addLogFile(new File(localLogFile));
                log.debug("Log file: {}", (Object)localLogFile);
            }
        } else {
            File directory = new File(kmsLogsPath);
            if (directory.isDirectory()) {
                log.debug("Copying KMS logs from local path {} to {}", (Object)kmsLogsPath, (Object)targetFolder);
                Collection logFiles = FileUtils.listFiles((File)directory, null, (boolean)true);
                for (File logFile : logFiles) {
                    File destFile = new File(targetFolder, testMethodName + "-" + logFile.getName());
                    try {
                        FileUtils.copyFile((File)logFile, (File)destFile);
                        KurentoTest.addLogFile(destFile);
                        log.debug("Log file: {}", (Object)destFile);
                    }
                    catch (Throwable e) {
                        log.warn("Exception copy KMS file {} {}", e.getClass(), (Object)e.getMessage());
                    }
                }
            } else {
                log.warn("Path {} is not a directory", (Object)directory);
            }
        }
    }

    public void stopKms() {
        if (this.isKmsDocker) {
            Docker.getSingleton().stopContainer(this.dockerContainerName);
        } else {
            this.killKmsProcesses();
            if (this.isKmsRemote) {
                this.remoteKmsSshConnection.stop();
            }
        }
        this.isKmsStarted = false;
    }

    private void killKmsProcesses() {
        int numKmsProcesses = 0;
        long timeout = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() <= timeout) {
            this.kmsSigTerm();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if ((numKmsProcesses = this.countKmsProcesses()) > 0) continue;
        }
        if (numKmsProcesses > 0) {
            this.kmsSigKill();
        }
    }

    private void kmsSigTerm() {
        log.trace("Sending SIGTERM to KMS process");
        if (this.isKmsRemote) {
            String kmsPid = this.remoteKmsSshConnection.execAndWaitCommandNoBr("cat", this.remoteKmsSshConnection.getTmpFolder() + "/kms-pid");
            this.remoteKmsSshConnection.runAndWaitCommand("kill", kmsPid);
        } else {
            Shell.runAndWait("sh", "-c", "kill `cat " + this.workspace + File.separator + "kms-pid`");
        }
    }

    private void kmsSigKill() {
        log.trace("Sending SIGKILL to KMS process");
        if (this.isKmsRemote) {
            String kmsPid = this.remoteKmsSshConnection.execAndWaitCommandNoBr("cat", this.remoteKmsSshConnection.getTmpFolder() + "/kms-pid");
            this.remoteKmsSshConnection.runAndWaitCommand("sh", "-c", "kill -9 " + kmsPid);
        } else {
            Shell.runAndWait("sh", "-c", "kill -9 `cat " + this.workspace + File.separator + "kms-pid`");
        }
    }

    private int countKmsProcesses() {
        int result = 0;
        try {
            if (this.isKmsRemote) {
                String kmsPid = this.remoteKmsSshConnection.execAndWaitCommandNoBr("cat", this.remoteKmsSshConnection.getTmpFolder() + "/kms-pid");
                result = Integer.parseInt(this.remoteKmsSshConnection.execAndWaitCommandNoBr("ps --pid " + kmsPid + " --no-headers | wc -l"));
            } else {
                String[] command = new String[]{"sh", "-c", "ps --pid `cat " + this.workspace + File.separator + "kms-pid` --no-headers | wc -l"};
                Process countKms = Runtime.getRuntime().exec(command);
                String stringFromStream = CharStreams.toString((Readable)new InputStreamReader(countKms.getInputStream(), "UTF-8"));
                result = Integer.parseInt(stringFromStream.trim());
            }
        }
        catch (IOException e) {
            log.warn("Exception counting KMS processes", (Throwable)e);
        }
        return result;
    }

    private void deleteFolderAndContent(Path folder) throws IOException {
        if (folder != null) {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public synchronized void setDockerContainerName(String containerName) {
        this.dockerContainerName = containerName;
        if (monitoredDockerContainerName == null) {
            monitoredDockerContainerName = this.dockerContainerName;
        }
    }

    private String getServerCommand() {
        return PropertiesManager.getProperty((String)"kms.command", (String)"/usr/bin/kurento-media-server");
    }

    private String getGstPlugins() {
        return PropertiesManager.getProperty((String)"kms.gst.plugins", (String)"");
    }

    private String getDebugOptions() {
        return PropertiesManager.getProperty((String)"kms.debug", (String)"2,*media_server*:5,*Kurento*:5,KurentoMediaServerServiceHandler:7");
    }

    public KurentoClient getKurentoClient() {
        if (this.kurentoClient == null && this.wsUri != null) {
            this.kurentoClient = this.createKurentoClient();
            this.kurentoClient.getServerManager().addObjectCreatedListener((EventListener)new EventListener<ObjectCreatedEvent>(){

                public void onEvent(ObjectCreatedEvent event) {
                    if (event instanceof MediaPipeline) {
                        MediaPipeline mp = (MediaPipeline)event;
                        mp.addErrorListener((EventListener)new EventListener<ErrorEvent>(){

                            public void onEvent(ErrorEvent event) {
                                String msgException = "Error in KMS: " + event.getDescription() + "; Type: " + event.getType() + "; Error Code: " + event.getErrorCode();
                                TestService.log.error(msgException);
                                throw new KurentoException(msgException);
                            }
                        });
                    }
                }
            });
        }
        return this.kurentoClient;
    }

    public KurentoClient createKurentoClient() {
        return KurentoClient.create((String)this.wsUri);
    }

    public void closeKurentoClient() {
        if (this.kurentoClient != null) {
            this.kurentoClient.destroy();
            this.kurentoClient = null;
        }
    }

    public String getWsUri() {
        return this.wsUri;
    }

    public void setWsUri(String wsUri) {
        if (wsUri != null) {
            System.setProperty(this.kmsWsUriExportProp, wsUri);
        }
        this.wsUri = wsUri;
    }

    public void setRegistrarUri(String registrarUri) {
        this.registrarUri = registrarUri;
    }

    public void setRegistrarLocalAddress(String registrarLocalAddress) {
        this.registrarLocalAddress = registrarLocalAddress;
    }

    public boolean isKmsStarted() {
        return this.isKmsStarted;
    }

    public static String getMonitoredDockerContainerName() {
        return monitoredDockerContainerName;
    }
}

