/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionManager;

public final class IdleConnectionReaper
extends Thread {
    private static final int PERIOD_MILLISECONDS = 60000;
    private static ArrayList<ClientConnectionManager> connectionManagers = new ArrayList();
    private static IdleConnectionReaper instance;
    static final Log log;

    private IdleConnectionReaper() {
        super("java-sdk-http-connection-reaper");
        this.setDaemon(true);
        this.start();
    }

    public static synchronized void registerConnectionManager(ClientConnectionManager connectionManager) {
        if (instance == null) {
            instance = new IdleConnectionReaper();
        }
        connectionManagers.add(connectionManager);
    }

    public static synchronized void removeConnectionManager(ClientConnectionManager connectionManager) {
        connectionManagers.remove(connectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            block6: while (true) {
                Thread.sleep(60000L);
                List connectionManagers = null;
                Class<IdleConnectionReaper> clazz = IdleConnectionReaper.class;
                // MONITORENTER : com.amazonaws.http.IdleConnectionReaper.class
                connectionManagers = (List)IdleConnectionReaper.connectionManagers.clone();
                // MONITOREXIT : clazz
                Iterator i$ = connectionManagers.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block6;
                    ClientConnectionManager connectionManager = (ClientConnectionManager)i$.next();
                    try {
                        connectionManager.closeIdleConnections(60L, TimeUnit.SECONDS);
                    }
                    catch (Throwable t) {
                        log.warn((Object)"Unable to close idle connections", t);
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    public static synchronized void shutdown() {
        if (instance != null) {
            instance.interrupt();
            connectionManagers.clear();
            instance = null;
        }
    }

    static {
        log = LogFactory.getLog(IdleConnectionReaper.class);
    }
}

