/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.ListClustersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListClustersRequestMarshaller
implements Marshaller<Request<ListClustersRequest>, ListClustersRequest> {
    @Override
    public Request<ListClustersRequest> marshall(ListClustersRequest listClustersRequest) {
        if (listClustersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListClustersRequest> request = new DefaultRequest<ListClustersRequest>(listClustersRequest, "AmazonElasticMapReduce");
        String target = "ElasticMapReduce.ListClusters";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag clusterStatesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listClustersRequest.getCreatedAfter() != null) {
                jsonWriter.key("CreatedAfter").value(listClustersRequest.getCreatedAfter());
            }
            if (listClustersRequest.getCreatedBefore() != null) {
                jsonWriter.key("CreatedBefore").value(listClustersRequest.getCreatedBefore());
            }
            if (!((clusterStatesList = (ListWithAutoConstructFlag)listClustersRequest.getClusterStates()) == null || clusterStatesList.isAutoConstruct() && clusterStatesList.isEmpty())) {
                jsonWriter.key("ClusterStates");
                jsonWriter.array();
                for (String clusterStatesListValue : clusterStatesList) {
                    if (clusterStatesListValue == null) continue;
                    jsonWriter.value(clusterStatesListValue);
                }
                jsonWriter.endArray();
            }
            if (listClustersRequest.getMarker() != null) {
                jsonWriter.key("Marker").value(listClustersRequest.getMarker());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

