/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.Notifications;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatePipelineNotificationsRequestMarshaller
implements Marshaller<Request<UpdatePipelineNotificationsRequest>, UpdatePipelineNotificationsRequest> {
    @Override
    public Request<UpdatePipelineNotificationsRequest> marshall(UpdatePipelineNotificationsRequest updatePipelineNotificationsRequest) {
        if (updatePipelineNotificationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdatePipelineNotificationsRequest> request = new DefaultRequest<UpdatePipelineNotificationsRequest>(updatePipelineNotificationsRequest, "AmazonElasticTranscoder");
        String target = "EtsCustomerService.UpdatePipelineNotifications";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "2012-09-25/pipelines/{Id}/notifications";
        uriResourcePath = uriResourcePath.replace("{Id}", this.getString(updatePipelineNotificationsRequest.getId()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            Notifications notifications = updatePipelineNotificationsRequest.getNotifications();
            if (notifications != null) {
                jsonWriter.key("Notifications");
                jsonWriter.object();
                if (notifications.getProgressing() != null) {
                    jsonWriter.key("Progressing").value(notifications.getProgressing());
                }
                if (notifications.getCompleted() != null) {
                    jsonWriter.key("Completed").value(notifications.getCompleted());
                }
                if (notifications.getWarning() != null) {
                    jsonWriter.key("Warning").value(notifications.getWarning());
                }
                if (notifications.getError() != null) {
                    jsonWriter.key("Error").value(notifications.getError());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

