/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.log.Priority;

public class LogFunction
extends AbstractFunction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__log";
    private static final int MIN_PARAMETER_COUNT = 1;
    private static final int MAX_PARAMETER_COUNT = 4;
    private static final String DEFAULT_PRIORITY = "INFO";
    private static final String DEFAULT_SEPARATOR = " : ";
    private Object[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String value;
        String priorityString;
        String stringToLog = ((CompoundVariable)this.values[0]).execute();
        if (this.values.length > 1) {
            priorityString = ((CompoundVariable)this.values[1]).execute();
            if (priorityString.length() == 0) {
                priorityString = DEFAULT_PRIORITY;
            }
        } else {
            priorityString = DEFAULT_PRIORITY;
        }
        Throwable t = null;
        if (this.values.length > 2 && (value = ((CompoundVariable)this.values[2]).execute()).length() > 0) {
            t = new Throwable(value);
        }
        String comment = "";
        if (this.values.length > 3) {
            comment = ((CompoundVariable)this.values[3]).execute();
        }
        LogFunction.logDetails(log, stringToLog, priorityString, t, comment);
        return stringToLog;
    }

    private static void printDetails(PrintStream ps, String s, Throwable t, String c) {
        String tn = Thread.currentThread().getName();
        StringBuilder sb = new StringBuilder(80);
        sb.append("Log: ");
        sb.append(tn);
        if (c.length() > 0) {
            sb.append(" ");
            sb.append(c);
        } else {
            sb.append(DEFAULT_SEPARATOR);
        }
        sb.append(s);
        if (t != null) {
            sb.append(" ");
            ps.print(sb.toString());
            t.printStackTrace(ps);
        } else {
            ps.println(sb.toString());
        }
    }

    static void logDetails(Logger l, String s, String prio, Throwable t, String c) {
        if (prio.equalsIgnoreCase("OUT")) {
            LogFunction.printDetails(System.out, s, t, c);
        } else if (prio.equalsIgnoreCase("ERR")) {
            LogFunction.printDetails(System.err, s, t, c);
        } else {
            Priority p = Priority.getPriorityForName((String)prio);
            if (log.isPriorityEnabled(p)) {
                String tn = Thread.currentThread().getName();
                StringBuilder sb = new StringBuilder(40);
                sb.append(tn);
                if (c.length() > 0) {
                    sb.append(" ");
                    sb.append(c);
                } else {
                    sb.append(DEFAULT_SEPARATOR);
                }
                sb.append(s);
                log.log(p, sb.toString(), t);
            }
        }
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 4);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"log_function_string_ret"));
        desc.add(JMeterUtils.getResString((String)"log_function_level"));
        desc.add(JMeterUtils.getResString((String)"log_function_throwable"));
        desc.add(JMeterUtils.getResString((String)"log_function_comment"));
    }
}

