/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.checkout;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.checkout.PerforceCheckOutConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceCheckOutCommand
extends AbstractCheckOutCommand
implements PerforceCommand {
    private String actualLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet files, ScmVersion version, boolean recursive) throws ScmException {
        block55: {
            block58: {
                block54: {
                    block53: {
                        prepo = (PerforceScmProviderRepository)repo;
                        workingDirectory = new File(files.getBasedir().getAbsolutePath());
                        this.actualLocation = PerforceScmProvider.getRepoPath(this.getLogger(), prepo, files.getBasedir());
                        specname = PerforceScmProvider.getClientspecName(this.getLogger(), prepo, workingDirectory);
                        consumer = new PerforceCheckOutConsumer(specname, this.actualLocation);
                        if (this.getLogger().isInfoEnabled()) {
                            this.getLogger().info("Checkout working directory: " + workingDirectory);
                        }
                        cl = null;
                        try {
                            cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                            cl.createArg().setValue("client");
                            cl.createArg().setValue("-i");
                            if (this.getLogger().isInfoEnabled()) {
                                this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                            }
                            client = PerforceScmProvider.createClientspec(this.getLogger(), prepo, workingDirectory, this.actualLocation);
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Updating clientspec:\n" + client);
                            }
                            err = new CommandLineUtils.StringStreamConsumer();
                            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (InputStream)new ByteArrayInputStream(client.getBytes()), (StreamConsumer)consumer, (StreamConsumer)err);
                            if (exitCode != 0) {
                                cmdLine = CommandLineUtils.toString((String[])cl.getCommandline());
                                msg = new StringBuilder("Exit code: " + exitCode + " - " + err.getOutput());
                                msg.append('\n');
                                msg.append("Command line was:" + cmdLine);
                                throw new CommandLineException(msg.toString());
                            }
                        }
                        catch (CommandLineException e) {
                            if (!this.getLogger().isErrorEnabled()) break block53;
                            this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                        }
                    }
                    clientspecExists = consumer.isSuccess();
                    if (clientspecExists) {
                        try {
                            this.getLastChangelist(prepo, workingDirectory, specname);
                            cl = PerforceCheckOutCommand.createCommandLine(prepo, workingDirectory, version, specname);
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Executing: " + PerforceScmProvider.clean(cl.toString()));
                            }
                            proc = cl.execute();
                            br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                            while ((line = br.readLine()) != null) {
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("Consuming: " + line);
                                }
                                consumer.consumeLine(line);
                            }
                            err = new CommandLineUtils.StringStreamConsumer();
                            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)err);
                            if (exitCode != 0) {
                                cmdLine = CommandLineUtils.toString((String[])cl.getCommandline());
                                msg = new StringBuilder("Exit code: " + exitCode + " - " + err.getOutput());
                                msg.append('\n');
                                msg.append("Command line was:" + cmdLine);
                                throw new CommandLineException(msg.toString());
                            }
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Perforce sync complete.");
                            }
                        }
                        catch (CommandLineException e) {
                            if (this.getLogger().isErrorEnabled()) {
                                this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                            }
                        }
                        catch (IOException e) {
                            if (!this.getLogger().isErrorEnabled()) break block54;
                            this.getLogger().error("IOException " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (!consumer.isSuccess()) break block57;
                var11_13 = new CheckOutScmResult(cl.toString(), consumer.getCheckedout());
                var19_25 = null;
                if (!clientspecExists || prepo.isPersistCheckout()) break block58;
                isReader = null;
                isReaderErr = null;
                try {
                    cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                    cl.createArg().setValue("client");
                    cl.createArg().setValue("-d");
                    cl.createArg().setValue(specname);
                    if (this.getLogger().isInfoEnabled()) {
                        this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                    }
                    proc = cl.execute();
                    isReader = new InputStreamReader(proc.getInputStream());
                    br = new BufferedReader(isReader);
                    while ((line = br.readLine()) != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Consuming: " + line);
                        }
                        consumer.consumeLine(line);
                    }
                    br.close();
                    isReaderErr = new InputStreamReader(proc.getErrorStream());
                    brErr = new BufferedReader(isReaderErr);
                    while ((line = brErr.readLine()) != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Consuming stderr: " + line);
                        }
                        consumer.consumeLine(line);
                    }
                    brErr.close();
                    var27_52 = null;
                }
                catch (Throwable var26_64) {
                    var27_55 = null;
                    IOUtil.close(isReader);
                    IOUtil.close(isReaderErr);
                    throw var26_64;
                }
                IOUtil.close((Reader)isReader);
                IOUtil.close((Reader)isReaderErr);
                {
                    ** GOTO lbl-1000
                    catch (CommandLineException e) {
                        if (this.getLogger().isErrorEnabled()) {
                            this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                        }
                        var27_53 = null;
                        IOUtil.close(isReader);
                        IOUtil.close(isReaderErr);
                        ** GOTO lbl-1000
                    }
                    catch (IOException e) {
                        if (this.getLogger().isErrorEnabled()) {
                            this.getLogger().error("IOException " + e.getMessage(), (Throwable)e);
                        }
                        var27_54 = null;
                        IOUtil.close(isReader);
                        IOUtil.close(isReaderErr);
                        ** GOTO lbl-1000
                    }
                }
            }
            if (!clientspecExists) ** GOTO lbl-1000
            System.setProperty("maven.scm.perforce.clientspec.name", specname);
lbl-1000:
            // 5 sources

            {
                block57: {
                    return var11_13;
                }
                var11_13 = new CheckOutScmResult(cl.toString(), "Unable to sync.  Are you logged in?", consumer.getOutput(), consumer.isSuccess());
            }
            var19_26 = null;
            if (clientspecExists && !prepo.isPersistCheckout()) {
                isReader = null;
                isReaderErr = null;
                try {
                    cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                    cl.createArg().setValue("client");
                    cl.createArg().setValue("-d");
                    cl.createArg().setValue(specname);
                    if (this.getLogger().isInfoEnabled()) {
                        this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                    }
                    proc = cl.execute();
                    isReader = new InputStreamReader(proc.getInputStream());
                    br = new BufferedReader(isReader);
                    while ((line = br.readLine()) != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Consuming: " + line);
                        }
                        consumer.consumeLine(line);
                    }
                    br.close();
                    isReaderErr = new InputStreamReader(proc.getErrorStream());
                    brErr = new BufferedReader(isReaderErr);
                    while ((line = brErr.readLine()) != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Consuming stderr: " + line);
                        }
                        consumer.consumeLine(line);
                    }
                    brErr.close();
                    var27_56 = null;
                }
                catch (Throwable var26_65) {
                    var27_59 = null;
                    IOUtil.close(isReader);
                    IOUtil.close(isReaderErr);
                    throw var26_65;
                }
                IOUtil.close((Reader)isReader);
                IOUtil.close((Reader)isReaderErr);
                {
                    break block55;
                    catch (CommandLineException e) {
                        if (this.getLogger().isErrorEnabled()) {
                            this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                        }
                        var27_57 = null;
                        IOUtil.close(isReader);
                        IOUtil.close(isReaderErr);
                        break block55;
                    }
                    catch (IOException e) {
                        if (this.getLogger().isErrorEnabled()) {
                            this.getLogger().error("IOException " + e.getMessage(), (Throwable)e);
                        }
                        var27_58 = null;
                        IOUtil.close(isReader);
                        IOUtil.close(isReaderErr);
                        break block55;
                    }
                }
            }
            if (clientspecExists) {
                System.setProperty("maven.scm.perforce.clientspec.name", specname);
            }
        }
        return var11_13;
        catch (Throwable var18_67) {
            block56: {
                var19_27 = null;
                if (clientspecExists && !prepo.isPersistCheckout()) {
                    isReader = null;
                    isReaderErr = null;
                    try {
                        cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                        cl.createArg().setValue("client");
                        cl.createArg().setValue("-d");
                        cl.createArg().setValue(specname);
                        if (this.getLogger().isInfoEnabled()) {
                            this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                        }
                        proc = cl.execute();
                        isReader = new InputStreamReader(proc.getInputStream());
                        br = new BufferedReader(isReader);
                        while ((line = br.readLine()) != null) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Consuming: " + line);
                            }
                            consumer.consumeLine(line);
                        }
                        br.close();
                        isReaderErr = new InputStreamReader(proc.getErrorStream());
                        brErr = new BufferedReader(isReaderErr);
                        while ((line = brErr.readLine()) != null) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Consuming stderr: " + line);
                            }
                            consumer.consumeLine(line);
                        }
                        brErr.close();
                        var27_60 = null;
                    }
                    catch (Throwable var26_66) {
                        var27_63 = null;
                        IOUtil.close(isReader);
                        IOUtil.close(isReaderErr);
                        throw var26_66;
                    }
                    IOUtil.close((Reader)isReader);
                    IOUtil.close((Reader)isReaderErr);
                    {
                        break block56;
                        catch (CommandLineException e) {
                            if (this.getLogger().isErrorEnabled()) {
                                this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                            }
                            var27_61 = null;
                            IOUtil.close(isReader);
                            IOUtil.close(isReaderErr);
                            break block56;
                        }
                        catch (IOException e) {
                            if (this.getLogger().isErrorEnabled()) {
                                this.getLogger().error("IOException " + e.getMessage(), (Throwable)e);
                            }
                            var27_62 = null;
                            IOUtil.close(isReader);
                            IOUtil.close(isReaderErr);
                            break block56;
                        }
                    }
                }
                if (!clientspecExists) break block56;
                System.setProperty("maven.scm.perforce.clientspec.name", specname);
            }
            throw var18_67;
        }
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmVersion version, String specname) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArg().setValue("-c" + specname);
        command.createArg().setValue("sync");
        String[] files = workingDirectory.list();
        if (files == null || files.length == 0) {
            command.createArg().setValue("-f");
        }
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            command.createArg().setValue("@" + version.getName());
        }
        return command;
    }

    private int getLastChangelist(PerforceScmProviderRepository repo, File workingDirectory, String specname) {
        int lastChangelist = 0;
        try {
            String line;
            Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
            command.createArg().setValue("-c" + specname);
            command.createArg().setValue("changes");
            command.createArg().setValue("-m1");
            command.createArg().setValue("-ssubmitted");
            command.createArg().setValue("//" + specname + "/...");
            this.getLogger().debug("Executing: " + PerforceScmProvider.clean(command.toString()));
            Process proc = command.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String lastChangelistStr = "";
            while ((line = br.readLine()) != null) {
                this.getLogger().debug("Consuming: " + line);
                Pattern changeRegexp = Pattern.compile("Change (\\d+)");
                Matcher matcher = changeRegexp.matcher(line);
                if (!matcher.find()) continue;
                lastChangelistStr = matcher.group(1);
            }
            br.close();
            try {
                lastChangelist = Integer.parseInt(lastChangelistStr);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().debug("Could not parse changelist from line " + line);
            }
        }
        catch (IOException e) {
            this.getLogger().error((Throwable)e);
        }
        catch (CommandLineException e) {
            this.getLogger().error((Throwable)e);
        }
        return lastChangelist;
    }
}

