/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import org.openqa.selenium.Keys;

public class InputKeysContainer {
    private final StringBuilder builder = new StringBuilder();
    private final boolean submitKeyFound;
    private boolean capitalize = false;

    public InputKeysContainer(CharSequence ... sequences) {
        this(false, sequences);
    }

    public InputKeysContainer(boolean trimPastEnterKey, CharSequence ... sequences) {
        for (CharSequence seq : sequences) {
            this.builder.append(seq);
        }
        int indexOfSubmitKey = this.indexOfSubmitKey();
        boolean bl = this.submitKeyFound = indexOfSubmitKey != -1;
        if (trimPastEnterKey && indexOfSubmitKey != -1) {
            this.builder.delete(indexOfSubmitKey, this.builder.length());
        }
    }

    private int indexOfSubmitKey() {
        CharSequence[] terminators;
        for (CharSequence terminator : terminators = new CharSequence[]{"\n", Keys.ENTER, Keys.RETURN}) {
            String needle = String.valueOf(terminator);
            int index = this.builder.indexOf(needle);
            if (index == -1) continue;
            return index;
        }
        return -1;
    }

    public String toString() {
        String toReturn = this.builder.toString();
        toReturn = toReturn.replaceAll(Keys.ENTER.toString(), "\r");
        toReturn = toReturn.replaceAll(Keys.RETURN.toString(), "\r");
        if (this.capitalize) {
            return toReturn.toUpperCase();
        }
        return toReturn;
    }

    public boolean wasSubmitKeyFound() {
        return this.submitKeyFound;
    }

    public void setCapitalization(boolean capitalize) {
        this.capitalize = capitalize;
    }
}

