/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.Logger;

public class Loader {
    private static final Logger logger = Logger.create(Loader.class);
    private static final String PLATFORM;
    private static java.util.Properties platformProperties;
    static File cacheDir;
    static File tempDir;
    static Map<String, String> loadedLibraries;
    static WeakHashMap<Class<? extends Pointer>, HashMap<String, Integer>> memberOffsets;

    public static String getPlatform() {
        return System.getProperty("org.bytedeco.javacpp.platform", PLATFORM);
    }

    public static java.util.Properties loadProperties() {
        String name = Loader.getPlatform();
        if (platformProperties != null && name.equals(platformProperties.getProperty("platform"))) {
            return platformProperties;
        }
        platformProperties = Loader.loadProperties(name, null);
        return platformProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static java.util.Properties loadProperties(String name, String defaults) {
        java.util.Properties p;
        block29: {
            p = new java.util.Properties();
            p.put("platform", name);
            p.put("platform.path.separator", File.pathSeparator);
            String s = System.mapLibraryName("/");
            int i = s.indexOf(47);
            p.put("platform.library.prefix", s.substring(0, i));
            p.put("platform.library.suffix", s.substring(i + 1));
            name = "properties/" + name + ".properties";
            InputStream is = Loader.class.getResourceAsStream(name);
            try {
                try {
                    p.load(new InputStreamReader(is));
                }
                catch (NoSuchMethodError e) {
                    p.load(is);
                }
            }
            catch (Exception e) {
                name = "properties/" + defaults + ".properties";
                InputStream is2 = Loader.class.getResourceAsStream(name);
                try {
                    p.load(new InputStreamReader(is2));
                }
                catch (NoSuchMethodError e2) {
                    p.load(is2);
                }
                try {
                    if (is2 != null) {
                        is2.close();
                    }
                    break block29;
                }
                catch (IOException ex) {
                    logger.error("Unable to close resource : " + ex.getMessage());
                }
                break block29;
                catch (Exception ex) {
                    try {
                        if (is2 != null) {
                            is2.close();
                        }
                        break block29;
                    }
                    catch (IOException ex2) {
                        logger.error("Unable to close resource : " + ex2.getMessage());
                    }
                    break block29;
                    catch (Throwable throwable) {
                        try {
                            if (is2 != null) {
                                is2.close();
                            }
                        }
                        catch (IOException ex3) {
                            logger.error("Unable to close resource : " + ex3.getMessage());
                        }
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    logger.error("Unable to close resource : " + ex.getMessage());
                }
            }
        }
        return p;
    }

    public static Class getEnclosingClass(Class cls) {
        Platform p;
        Class<?> c = cls;
        while (c.getDeclaringClass() != null && !c.isAnnotationPresent(Properties.class) && (!c.isAnnotationPresent(Platform.class) || (p = c.getAnnotation(Platform.class)).pragma().length <= 0 && p.define().length <= 0 && p.include().length <= 0 && p.cinclude().length <= 0 && p.includepath().length <= 0 && p.compiler().length <= 0 && p.linkpath().length <= 0 && p.link().length <= 0 && p.frameworkpath().length <= 0 && p.framework().length <= 0 && p.preloadpath().length <= 0 && p.preload().length <= 0 && p.library().length() <= 0)) {
            c = c.getDeclaringClass();
        }
        return c;
    }

    public static ClassProperties loadProperties(Class[] cls, java.util.Properties properties, boolean inherit) {
        ClassProperties cp = new ClassProperties(properties);
        for (Class c : cls) {
            cp.load(c, inherit);
        }
        return cp;
    }

    public static ClassProperties loadProperties(Class cls, java.util.Properties properties, boolean inherit) {
        ClassProperties cp = new ClassProperties(properties);
        cp.load(cls, inherit);
        return cp;
    }

    public static Class getCallerClass(int i) {
        Object classContext = null;
        try {
            new SecurityManager(){

                public Class[] getClassContext() {
                    return super.getClassContext();
                }
            }.getClassContext();
        }
        catch (NoSuchMethodError e) {
            logger.error("No definition of this method : " + e.getMessage());
        }
        if (classContext != null) {
            for (int j = 0; j < (classContext).length; ++j) {
                if (classContext[j] != Loader.class) continue;
                return classContext[i + j];
            }
        } else {
            try {
                StackTraceElement[] classNames = Thread.currentThread().getStackTrace();
                for (int j = 0; j < classNames.length; ++j) {
                    if (Class.forName(classNames[j].getClassName()) != Loader.class) continue;
                    return Class.forName(classNames[i + j].getClassName());
                }
            }
            catch (ClassNotFoundException e) {
                logger.error("No definition for the class found : " + e.getMessage());
            }
        }
        return null;
    }

    public static File extractResource(String name, File directory, String prefix, String suffix) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.extractResource(cls, name, directory, prefix, suffix);
    }

    public static File extractResource(Class cls, String name, File directory, String prefix, String suffix) throws IOException {
        return Loader.extractResource(cls.getResource(name), directory, prefix, suffix);
    }

    public static File extractResource(URL resourceURL, File directory, String prefix, String suffix) throws IOException {
        InputStream is = resourceURL != null ? resourceURL.openStream() : null;
        OutputStream os = null;
        if (is == null) {
            return null;
        }
        File file = null;
        boolean fileExisted = false;
        try {
            int length;
            if (prefix == null && suffix == null) {
                if (directory == null) {
                    directory = new File(System.getProperty("java.io.tmpdir"));
                }
                file = new File(directory, new File(resourceURL.getPath()).getName());
                fileExisted = file.exists();
            } else {
                file = File.createTempFile(prefix, suffix, directory);
            }
            os = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            if (file != null && !fileExisted) {
                file.delete();
            }
            throw e;
        }
        finally {
            is.close();
            if (os != null) {
                os.close();
            }
        }
        return file;
    }

    public static File getCacheDir() {
        File f;
        String dirName;
        if (cacheDir == null && (dirName = System.getProperty("org.bytedeco.javacpp.cachedir", null)) != null && ((f = new File(dirName)).exists() || f.mkdirs())) {
            cacheDir = f;
        }
        return cacheDir;
    }

    public static File getTempDir() {
        if (tempDir == null) {
            File tmpdir = new File(System.getProperty("java.io.tmpdir"));
            for (int i = 0; i < 1000; ++i) {
                File f = new File(tmpdir, "javacpp" + System.nanoTime());
                if (!f.mkdir()) continue;
                tempDir = f;
                tempDir.deleteOnExit();
                break;
            }
        }
        return tempDir;
    }

    public static boolean isLoadLibraries() {
        String s = System.getProperty("org.bytedeco.javacpp.loadlibraries", "true").toLowerCase();
        return s.equals("true") || s.equals("t") || s.equals("");
    }

    public static String load() {
        return Loader.load(Loader.getCallerClass(2), Loader.loadProperties(), false);
    }

    public static String load(boolean pathsFirst) {
        Class cls = Loader.getCallerClass(2);
        return Loader.load(cls, Loader.loadProperties(), pathsFirst);
    }

    public static String load(Class cls) {
        return Loader.load(cls, Loader.loadProperties(), false);
    }

    public static String load(Class cls, java.util.Properties properties, boolean pathsFirst) {
        if (!Loader.isLoadLibraries() || cls == null) {
            return null;
        }
        ClassProperties p = Loader.loadProperties(cls = Loader.getEnclosingClass(cls), properties, true);
        List<String> targets = p.get("target");
        if (targets.isEmpty()) {
            if (p.getInheritedClasses() != null) {
                for (Class c : p.getInheritedClasses()) {
                    targets.add(c.getName());
                }
            }
            targets.add(cls.getName());
        }
        for (String s : targets) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Loading class " + s);
                }
                Class.forName(s, true, cls.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to load class " + s + ": " + ex);
                }
                NoClassDefFoundError e = new NoClassDefFoundError(ex.toString());
                e.initCause(ex);
                throw e;
            }
        }
        ArrayList<String> preloads = new ArrayList<String>();
        preloads.addAll(p.get("platform.preload"));
        preloads.addAll(p.get("platform.link"));
        UnsatisfiedLinkError preloadError = null;
        for (String preload : preloads) {
            try {
                URL[] urls = Loader.findLibrary(cls, p, preload, pathsFirst);
                Loader.loadLibrary(urls, preload);
            }
            catch (UnsatisfiedLinkError e) {
                preloadError = e;
            }
        }
        try {
            String library = p.getProperty("platform.library");
            URL[] urls = Loader.findLibrary(cls, p, library, pathsFirst);
            return Loader.loadLibrary(urls, library);
        }
        catch (UnsatisfiedLinkError e) {
            if (preloadError != null && e.getCause() == null) {
                e.initCause(preloadError);
            }
            throw e;
        }
    }

    public static URL[] findLibrary(Class cls, ClassProperties properties, String libnameversion, boolean pathsFirst) {
        String[] s = libnameversion.split("@");
        String libname = s[0];
        String version = s.length > 1 ? s[s.length - 1] : "";
        String filename = loadedLibraries.get(libnameversion);
        if (filename != null) {
            try {
                return new URL[]{new File(filename).toURI().toURL()};
            }
            catch (IOException ex) {
                return new URL[0];
            }
        }
        String subdir = properties.getProperty("platform") + '/';
        String prefix = properties.getProperty("platform.library.prefix", "") + libname;
        String suffix = properties.getProperty("platform.library.suffix", "");
        String[] styles = new String[]{prefix + suffix + version, prefix + version + suffix, prefix + suffix};
        String[] suffixes = properties.get("platform.library.suffix").toArray(new String[0]);
        if (suffixes.length > 1) {
            styles = new String[3 * suffixes.length];
            for (int i = 0; i < suffixes.length; ++i) {
                styles[3 * i] = prefix + suffixes[i] + version;
                styles[3 * i + 1] = prefix + version + suffixes[i];
                styles[3 * i + 2] = prefix + suffixes[i];
            }
        }
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(properties.get("platform.preloadpath"));
        paths.addAll(properties.get("platform.linkpath"));
        String libpath = System.getProperty("java.library.path", "");
        if (libpath.length() > 0) {
            paths.addAll(Arrays.asList(libpath.split(File.pathSeparator)));
        }
        ArrayList<URL> urls = new ArrayList<URL>(styles.length * (1 + paths.size()));
        for (int i = 0; cls != null && i < styles.length; ++i) {
            URL u = cls.getResource(subdir + styles[i]);
            if (u == null) continue;
            urls.add(u);
        }
        int k = pathsFirst ? 0 : urls.size();
        for (int i = 0; paths.size() > 0 && i < styles.length; ++i) {
            for (String path : paths) {
                File file = new File(path, styles[i]);
                if (!file.exists()) continue;
                try {
                    urls.add(k++, file.toURI().toURL());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static String loadLibrary(URL[] urls, String libnameversion) {
        String libname;
        if (!Loader.isLoadLibraries()) {
            return null;
        }
        String filename = loadedLibraries.get(libnameversion);
        if (filename != null) {
            return filename;
        }
        File tempFile = null;
        UnsatisfiedLinkError loadError = null;
        try {
            for (URL url : urls) {
                File file = new File(Loader.getCacheDir() != null ? Loader.getCacheDir() : Loader.getTempDir(), new File(url.getPath()).getName());
                if (!file.exists()) {
                    if (tempFile != null && tempFile.exists()) {
                        tempFile.deleteOnExit();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Extracting " + url);
                    }
                    file = Loader.getCacheDir() != null ? Loader.extractResource(url, Loader.getCacheDir(), null, null) : (tempFile = Loader.extractResource(url, Loader.getTempDir(), null, null));
                } else {
                    while (System.currentTimeMillis() - file.lastModified() < 1000L) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                if (file == null || !file.exists()) continue;
                filename = file.getAbsolutePath();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Loading " + filename);
                    }
                    loadedLibraries.put(libnameversion, filename);
                    System.load(filename);
                    String ex = filename;
                    return ex;
                }
                catch (UnsatisfiedLinkError e) {
                    loadError = e;
                    loadedLibraries.remove(libnameversion);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Failed to load " + filename + ": " + e);
                }
            }
            libname = libnameversion.split("@")[0];
            if (logger.isDebugEnabled()) {
                logger.debug("Loading library " + libname);
            }
            loadedLibraries.put(libnameversion, libname);
        }
        catch (UnsatisfiedLinkError e) {
            loadedLibraries.remove(libnameversion);
            if (loadError != null && e.getCause() == null) {
                e.initCause(loadError);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to load for " + libnameversion + ": " + e);
            }
            throw e;
        }
        catch (IOException ex) {
            loadedLibraries.remove(libnameversion);
            if (loadError != null && ex.getCause() == null) {
                ex.initCause(loadError);
            }
            UnsatisfiedLinkError e = new UnsatisfiedLinkError(ex.toString());
            e.initCause(ex);
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to extract for " + libnameversion + ": " + e);
            }
            throw e;
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.deleteOnExit();
            }
        }
        System.loadLibrary(libname);
        String string = libname;
        return string;
    }

    public static void main(String[] args) throws InterruptedException {
        File tempDir;
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        if (!tmpdir.equals((tempDir = new File(args[0])).getParentFile()) || !tempDir.getName().startsWith("javacpp")) {
            return;
        }
        for (File file : tempDir.listFiles()) {
            while (file.exists() && !file.delete()) {
                Thread.sleep(100L);
            }
        }
        tempDir.delete();
    }

    static Class putMemberOffset(String typeName, String member, int offset) throws ClassNotFoundException {
        Class<?> c = Class.forName(typeName.replace('/', '.'), false, Loader.class.getClassLoader());
        if (member != null) {
            Loader.putMemberOffset(c.asSubclass(Pointer.class), member, offset);
        }
        return c;
    }

    static synchronized void putMemberOffset(Class<? extends Pointer> type, String member, int offset) {
        HashMap<String, Integer> offsets = memberOffsets.get(type);
        if (offsets == null) {
            offsets = new HashMap();
            memberOffsets.put(type, offsets);
        }
        offsets.put(member, offset);
    }

    public static int offsetof(Class<? extends Pointer> type, String member) {
        return memberOffsets.get(type).get(member);
    }

    public static int sizeof(Class<? extends Pointer> type) {
        return memberOffsets.get(type).get("sizeof");
    }

    static {
        platformProperties = null;
        String jvmName = System.getProperty("java.vm.name", "").toLowerCase();
        String osName = System.getProperty("os.name", "").toLowerCase();
        String osArch = System.getProperty("os.arch", "").toLowerCase();
        String abiType = System.getProperty("sun.arch.abi", "").toLowerCase();
        if (jvmName.startsWith("dalvik") && osName.startsWith("linux")) {
            osName = "android";
        } else if (jvmName.startsWith("robovm") && osName.startsWith("darwin")) {
            osName = "ios";
            osArch = "arm";
        } else if (osName.startsWith("mac os x") || osName.startsWith("darwin")) {
            osName = "macosx";
        } else {
            int spaceIndex = osName.indexOf(32);
            if (spaceIndex > 0) {
                osName = osName.substring(0, spaceIndex);
            }
        }
        if (osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686")) {
            osArch = "x86";
        } else if (osArch.equals("amd64") || osArch.equals("x86-64") || osArch.equals("x64")) {
            osArch = "x86_64";
        } else if (osArch.startsWith("aarch64") || osArch.startsWith("armv8") || osArch.startsWith("arm64")) {
            osArch = "arm64";
        } else if (osArch.startsWith("arm") && abiType.equals("gnueabihf")) {
            osArch = "armhf";
        } else if (osArch.startsWith("arm")) {
            osArch = "arm";
        }
        PLATFORM = osName + "-" + osArch;
        cacheDir = null;
        tempDir = null;
        loadedLibraries = Collections.synchronizedMap(new HashMap());
        if (Loader.getPlatform().startsWith("windows")) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (tempDir == null) {
                        return;
                    }
                    try {
                        ArrayList<String> command = new ArrayList<String>();
                        command.add(System.getProperty("java.home") + "/bin/java");
                        command.add("-classpath");
                        command.add(new File(Loader.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toString());
                        command.add(Loader.class.getName());
                        command.add(tempDir.getAbsolutePath());
                        new ProcessBuilder(command).start();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        memberOffsets = new WeakHashMap();
    }
}

