/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.RenderedImage;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.AbstractImage;

public class ImageRendered
extends AbstractImage {
    private RenderedImage red;
    private Color transparentColor;

    public ImageRendered(ImageInfo info, RenderedImage red, Color transparentColor) {
        super(info);
        this.red = red;
        this.transparentColor = transparentColor;
    }

    public ImageFlavor getFlavor() {
        return ImageFlavor.RENDERED_IMAGE;
    }

    public boolean isCacheable() {
        return true;
    }

    public RenderedImage getRenderedImage() {
        return this.red;
    }

    public ColorSpace getColorSpace() {
        return this.getRenderedImage().getColorModel().getColorSpace();
    }

    public ICC_Profile getICCProfile() {
        ColorSpace cs = this.getColorSpace();
        if (cs instanceof ICC_ColorSpace) {
            ICC_ColorSpace icccs = (ICC_ColorSpace)cs;
            return icccs.getProfile();
        }
        return null;
    }

    public Color getTransparentColor() {
        return this.transparentColor;
    }
}

