/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.browser;

import com.google.common.base.Function;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.kurento.test.browser.Browser;
import org.kurento.test.browser.BrowserEventListener;
import org.kurento.test.browser.ConsoleLogLevel;
import org.kurento.test.grid.GridHandler;
import org.kurento.test.latency.LatencyException;
import org.kurento.test.latency.VideoTag;
import org.kurento.test.monitor.PeerConnectionStats;
import org.kurento.test.monitor.SystemMonitorManager;
import org.kurento.test.utils.Ffmpeg;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPage {
    public static Logger log = LoggerFactory.getLogger(WebPage.class);
    private Map<String, CountDownLatch> countDownLatchEvents = new HashMap<String, CountDownLatch>();
    private List<Thread> callbackThreads = new ArrayList<Thread>();
    public Browser browser;

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public void takeScreeshot(String file) throws IOException {
        File scrFile = (File)((TakesScreenshot)this.getBrowser().getWebDriver()).getScreenshotAs(OutputType.FILE);
        FileUtils.copyFile((File)scrFile, (File)new File(file));
    }

    public void setThresholdTime(int thresholdTime) {
        this.browser.setThresholdTime(thresholdTime);
    }

    public void setColorCoordinates(int x, int y) {
        this.browser.executeScript("kurentoTest.setColorCoordinates(" + x + "," + y + ");");
    }

    public void checkColor(String ... videoTags) {
        String tags = "";
        for (String s : videoTags) {
            if (!tags.isEmpty()) {
                tags = tags + ",";
            }
            tags = tags + "'" + s + "'";
        }
        this.browser.executeScript("kurentoTest.checkColor(" + tags + ");");
    }

    public boolean similarColorAt(String videoTag, Color expectedColor, int x, int y) {
        this.setColorCoordinates(x, y);
        return this.similarColor(videoTag, expectedColor);
    }

    public boolean similarColor(String videoTag, Color expectedColor) {
        boolean out;
        long endTimeMillis = System.currentTimeMillis() + (long)(this.browser.getTimeout() * 1000);
        boolean logWarn = true;
        while (!(out = this.compareColor(videoTag, expectedColor, logWarn)) && System.currentTimeMillis() <= endTimeMillis) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.trace("InterruptedException in guard condition ({})", (Object)e.getMessage());
            }
            logWarn = false;
        }
        return out;
    }

    public boolean compareColor(String videoTag, Color expectedColor, boolean logWarn) {
        boolean out;
        List realColor = (List)this.browser.executeScriptAndWaitOutput("return kurentoTest.colorInfo['" + videoTag + "'].currentColor;");
        long red = (Long)realColor.get(0);
        long green = (Long)realColor.get(1);
        long blue = (Long)realColor.get(2);
        double distance = Math.sqrt((red - (long)expectedColor.getRed()) * (red - (long)expectedColor.getRed()) + (green - (long)expectedColor.getGreen()) * (green - (long)expectedColor.getGreen()) + (blue - (long)expectedColor.getBlue()) * (blue - (long)expectedColor.getBlue()));
        String expectedColorStr = "[R=" + expectedColor.getRed() + ", G=" + expectedColor.getGreen() + ", B=" + expectedColor.getBlue() + "]";
        String realColorStr = "[R=" + red + ", G=" + green + ", B=" + blue + "]";
        boolean bl = out = distance <= this.browser.getColorDistance();
        if (!out) {
            if (logWarn) {
                log.warn("Color NOT detected in video stream. Expected: {}, Real: {}", (Object)expectedColorStr, (Object)realColorStr);
            }
        } else {
            log.debug("Detected color in video stream. Expected: {}, Real: {}", (Object)expectedColorStr, (Object)realColorStr);
        }
        return out;
    }

    public void activatePeerConnectionInboundStats(String peerConnectionId) {
        this.activatePeerConnectionStats("activateInboundRtcStats", peerConnectionId);
    }

    public void activatePeerConnectionOutboundStats(String peerConnectionId) {
        this.activatePeerConnectionStats("activateOutboundRtcStats", peerConnectionId);
    }

    private void activatePeerConnectionStats(String jsFunction, String peerConnectionId) {
        try {
            this.browser.executeScript("kurentoTest." + jsFunction + "('" + peerConnectionId + "');");
        }
        catch (WebDriverException we) {
            we.printStackTrace();
            log.warn("Client does not support RTC statistics (function kurentoTest.{}() not defined)", (Object)jsFunction);
        }
    }

    public void stopPeerConnectionInboundStats(String peerConnectionId) {
        this.stopPeerConnectionStats("stopInboundRtcStats", peerConnectionId);
    }

    public void stopPeerConnectionOutboundStats(String peerConnectionId) {
        this.stopPeerConnectionStats("stopOutboundRtcStats", peerConnectionId);
    }

    private void stopPeerConnectionStats(String jsFunction, String peerConnectionId) {
        try {
            log.debug("kurentoTest." + jsFunction + "('" + peerConnectionId + "');");
            this.browser.executeScript("kurentoTest." + jsFunction + "('" + peerConnectionId + "');");
        }
        catch (WebDriverException we) {
            we.printStackTrace();
            log.warn("Client does not support RTC statistics (function kurentoTest.{}() not defined)");
        }
    }

    public long getLatency() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final long[] out = new long[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                Object latency = WebPage.this.browser.executeScript("return kurentoTest.getLatency();");
                out[0] = latency != null ? (Long)latency : Long.MIN_VALUE;
                latch.countDown();
            }
        };
        t.start();
        if (!latch.await(this.browser.getTimeout(), TimeUnit.SECONDS)) {
            t.interrupt();
            t.stop();
            throw new LatencyException("Timeout getting latency (" + this.browser.getTimeout() + "  seconds)");
        }
        return out[0];
    }

    public void waitColor(long timeoutSeconds, final VideoTag videoTag, final Color color) {
        WebDriverWait wait = new WebDriverWait(this.browser.getWebDriver(), timeoutSeconds);
        wait.until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                return !((JavascriptExecutor)d).executeScript(videoTag.getColor(), new Object[0]).equals(color);
            }
        });
    }

    public long getCurrentTime(VideoTag videoTag) {
        Object time = this.browser.executeScript(videoTag.getTime());
        return time == null ? 0L : (Long)time;
    }

    public Color getCurrentColor(VideoTag videoTag) {
        return this.getColor((List)this.browser.executeScript(videoTag.getColor()));
    }

    private Color getColor(List<Long> color) {
        return new Color(color.get(0).intValue(), color.get(1).intValue(), color.get(2).intValue());
    }

    public void checkLatencyUntil(SystemMonitorManager monitor, long endTimeMillis) throws InterruptedException, IOException {
        while (System.currentTimeMillis() <= endTimeMillis) {
            Thread.sleep(100L);
            try {
                long latency = this.getLatency();
                if (latency == Long.MIN_VALUE) continue;
                monitor.addCurrentLatency(latency);
            }
            catch (LatencyException le) {
                monitor.incrementLatencyErrors();
            }
        }
    }

    public PeerConnectionStats getRtcStats() {
        Map<String, Object> out = new HashMap<String, Object>();
        try {
            if (this.browser != null && this.browser.getWebDriver() != null) {
                out = (Map)this.browser.executeScript("return kurentoTest.rtcStats;");
                log.debug(">>>>>>>>>> kurentoTest.rtcStats {} {}", (Object)this.browser.getId(), out);
            }
        }
        catch (WebDriverException we) {
            log.warn("Client does not support RTC statistics (variable rtcStats is not defined)");
        }
        return new PeerConnectionStats(out);
    }

    public void activateLatencyControl(String localId, String remoteId) {
        this.browser.executeScript("kurentoTest.activateLatencyControl('" + localId + "', '" + remoteId + "');");
    }

    public int getTimeout() {
        return this.browser.getTimeout();
    }

    public void setTimeout(int timeoutSeconds) {
        this.browser.changeTimeout(timeoutSeconds);
    }

    public int getThresholdTime() {
        return this.browser.getThresholdTime();
    }

    public boolean compareDataChannelMessage(String message) {
        String messageReceived;
        boolean out;
        long endTimeMillis = System.currentTimeMillis() + (long)(this.browser.getTimeout() * 1000);
        while (!(out = message.equals(messageReceived = (String)this.browser.executeScript("return kurentoTest.getDataChannelMessage()"))) && System.currentTimeMillis() <= endTimeMillis) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.trace("InterruptedException in guard condition ({})", (Object)e.getMessage());
            }
        }
        return out;
    }

    public void syncTimeForOcr(String videoTagId, String peerConnectionId) {
        this.browser.executeScript("kurentoTest.syncTimeForOcr('" + videoTagId + "', '" + peerConnectionId + "');");
        log.debug("Sync time in {} {}", (Object)this.browser.getId(), (Object)videoTagId);
        WebDriverWait wait = new WebDriverWait(this.browser.getWebDriver(), (long)this.browser.getTimeout());
        wait.until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                return (Boolean)((JavascriptExecutor)d).executeScript("return kurentoTest.sync;", new Object[0]);
            }
        });
        log.debug("[Done] Sync time in {} {}", (Object)this.browser.getId(), (Object)videoTagId);
    }

    public void startOcr() {
        this.browser.executeScript("kurentoTest.startOcr();");
    }

    public void endOcr() {
        this.browser.executeScript("kurentoTest.endOcr();");
    }

    public Map<String, Map<String, Object>> getOcrMap() {
        Map ocrMap = (Map)this.browser.executeScript("return kurentoTest.ocrMap;");
        TreeMap<String, Map<String, Object>> serializableMap = new TreeMap<String, Map<String, Object>>();
        for (String key : ocrMap.keySet()) {
            serializableMap.put(key, new HashMap((Map)ocrMap.get(key)));
        }
        return serializableMap;
    }

    public void startRecording(String stream) {
        this.browser.executeScript("kurentoTest.startRecording(" + stream + ");");
    }

    public void stopRecording() {
        this.browser.executeScript("kurentoTest.stopRecording();");
        this.getProperty("recordRTC");
    }

    public File saveRecordingToDisk(String fileName) {
        this.browser.executeScript("kurentoTest.saveRecordingToDisk('" + fileName + "');");
        String downloads = System.getProperty("user.home") + File.separator + "Downloads" + File.separator;
        File output = new File(downloads + fileName);
        while (!output.exists()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.warn("Exception waiting for file {}", (Object)output, (Object)e);
            }
        }
        return output;
    }

    public void openRecordingInNewTab() {
        this.browser.executeScript("kurentoTest.openRecordingInNewTab();");
    }

    public File getRecording() throws IOException {
        File tmpFile = File.createTempFile(String.valueOf(System.nanoTime()), ".webm");
        return this.getRecording(tmpFile.getAbsolutePath());
    }

    public File getRecording(String fileName) throws IOException {
        this.browser.executeScript("kurentoTest.recordingToData();");
        String recording = this.getProperty("recordingData").toString();
        File outputFile = new File(fileName);
        byte[] bytes = Base64.decodeBase64((String)recording.substring(recording.lastIndexOf(",") + 1));
        FileUtils.writeByteArrayToFile((File)outputFile, (byte[])bytes);
        return outputFile;
    }

    private Object getProperty(String property) {
        Object value = null;
        int pollTimeMs = 200;
        for (int i = 0; i < 60 && (value = this.browser.executeScript("return kurentoTest." + property + ";")) == null; ++i) {
            try {
                log.debug("{} not present still... waiting {} ms", (Object)property, (Object)200);
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                log.warn("Exception wait polling whil getting {}", (Object)property, (Object)e);
            }
        }
        String clazz = value != null ? value.getClass().getName() : "";
        log.trace(">>> getProperty {} {} {}", new Object[]{property, value, clazz});
        return value;
    }

    public void subscribeEvent(String videoTag, String eventType) {
        this.subscribeEventsToVideoTag("document.getElementById('" + videoTag + "')", eventType);
    }

    protected void subscribeEventsToVideoTag(final String videoTag, final String eventType) {
        CountDownLatch latch = new CountDownLatch(1);
        final String browserName = this.browser.getId();
        log.debug("Subscribe event '{}' in browser '{}'", (Object)eventType, (Object)browserName);
        this.countDownLatchEvents.put(browserName + eventType, latch);
        this.addEventListener(videoTag, eventType, new BrowserEventListener(){

            @Override
            public void onEvent(String event) {
                WebPage.this.consoleLog(ConsoleLogLevel.INFO, "Event in " + videoTag + " tag: " + event);
                ((CountDownLatch)WebPage.this.countDownLatchEvents.get(browserName + eventType)).countDown();
            }
        });
    }

    public boolean waitForEvent(String eventType) throws InterruptedException {
        String browserName = this.browser.getId();
        log.debug("Waiting for event '{}' in browser '{}'", (Object)eventType, (Object)browserName);
        if (!this.countDownLatchEvents.containsKey(browserName + eventType)) {
            log.error("We cannot wait for an event without previous subscription");
            return false;
        }
        boolean result = this.countDownLatchEvents.get(browserName + eventType).await(this.browser.getTimeout(), TimeUnit.SECONDS);
        if (eventType.equalsIgnoreCase("playing") && this.browser.getRecordAudio() > 0) {
            if (this.browser.isRemote()) {
                Ffmpeg.recordRemote(GridHandler.getInstance().getNode(this.browser.getId()), this.browser.getRecordAudio(), this.browser.getAudioSampleRate(), this.browser.getAudioChannel());
            } else {
                Ffmpeg.record(this.browser.getRecordAudio(), this.browser.getAudioSampleRate(), this.browser.getAudioChannel());
            }
        }
        this.countDownLatchEvents.remove(browserName + eventType);
        return result;
    }

    public void addEventListener(final String videoTag, final String eventType, final BrowserEventListener eventListener) {
        Thread t = new Thread(){

            @Override
            public void run() {
                WebPage.this.browser.executeScript(videoTag + ".addEventListener('" + eventType + "', kurentoTest.videoEvent, false);");
                try {
                    new WebDriverWait(WebPage.this.browser.getWebDriver(), (long)WebPage.this.browser.getTimeout()).until((Function)new ExpectedCondition<Boolean>(){

                        public Boolean apply(WebDriver d) {
                            Object videoEventValue = ((JavascriptExecutor)d).executeScript("return kurentoTest.videoEventValue;", new Object[0]);
                            return videoEventValue != null && videoEventValue.toString().equalsIgnoreCase(eventType);
                        }
                    });
                    eventListener.onEvent(eventType);
                }
                catch (Throwable t) {
                    log.error("~~~ Exception in addEventListener {}", (Object)t.getMessage());
                    t.printStackTrace();
                    this.interrupt();
                    this.stop();
                }
            }
        };
        this.callbackThreads.add(t);
        t.setDaemon(true);
        t.start();
    }

    public void consoleLog(ConsoleLogLevel level, String message) {
        message = message.replaceAll("'", "\"");
        this.browser.executeScript("console." + level.toString() + "('" + message + "');");
    }

    @After
    public void teardownKurentoServices() throws Exception {
        for (Thread t : this.callbackThreads) {
            t.stop();
        }
    }

    public void stopWebRtc() {
        this.browser.executeScript("stop();");
        this.browser.executeScript("var kurentoTest = new KurentoTest();");
        this.countDownLatchEvents.clear();
    }

    public void close() {
        this.browser.close();
    }
}

