/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import java.util.HashMap;
import java.util.Map;
import org.kurento.test.monitor.KmsSystemInfo;
import org.kurento.test.monitor.WebRtcStats;

public class MonitorSample {
    private int numClients = 0;
    private KmsSystemInfo kmsInfo;
    private Map<String, WebRtcStats> stats = new HashMap<String, WebRtcStats>();
    private double currentLatency = 0.0;
    private int latencyHints = 0;
    private int latencyErrors = 0;
    private boolean showLantency = false;

    public void addWebRtcStats(WebRtcStats webRtcStats) {
        this.stats.put(webRtcStats.getId(), webRtcStats);
    }

    public WebRtcStats getWebRtcStats(String id) {
        return this.stats.get(id);
    }

    public Map<String, WebRtcStats> getStats() {
        return this.stats;
    }

    public int getNumClients() {
        return this.numClients;
    }

    public void setNumClients(int numClients) {
        this.numClients = numClients;
    }

    public KmsSystemInfo getSystemInfo() {
        return this.kmsInfo;
    }

    public void setSystemInfo(KmsSystemInfo kmsInfo) {
        this.kmsInfo = kmsInfo;
    }

    public double getCurrentLatency() {
        return this.currentLatency;
    }

    public void setCurrentLatency(double currentLatency) {
        this.currentLatency = currentLatency;
    }

    public int getLatencyHints() {
        return this.latencyHints;
    }

    public void setLatencyHints(int latencyHints) {
        this.latencyHints = latencyHints;
    }

    public int getLatencyErrors() {
        return this.latencyErrors;
    }

    public void setLatencyErrors(int latencyErrors) {
        this.latencyErrors = latencyErrors;
    }

    public boolean isShowLantency() {
        return this.showLantency;
    }

    public void setShowLantency(boolean showLantency) {
        this.showLantency = showLantency;
    }

    public double getLatency() {
        double latency = this.latencyHints > 0 ? this.currentLatency / (double)this.latencyHints : 0.0;
        this.currentLatency = 0.0;
        this.latencyHints = 0;
        return latency;
    }
}

