/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

public class NetInfo
implements Serializable {
    private static final long serialVersionUID = -6318529719103095127L;
    private Map<String, NetInfoEntry> netInfoMap = new TreeMap<String, NetInfoEntry>();

    public void putNetInfo(String key, long rxBytes, long txBytes) {
        this.netInfoMap.put(key, new NetInfoEntry(rxBytes, txBytes));
    }

    public void decrementInitInfo(NetInfo initNetInfo) {
        for (String key : this.netInfoMap.keySet()) {
            this.netInfoMap.get(key).decrementRxBytes(initNetInfo.getNetInfoMap().get(key).getRxBytes());
            this.netInfoMap.get(key).decrementTxBytes(initNetInfo.getNetInfoMap().get(key).getTxBytes());
        }
    }

    public Map<String, NetInfoEntry> getNetInfoMap() {
        return this.netInfoMap;
    }

    public void setNetInfoMap(Map<String, NetInfoEntry> netInfoMap) {
        this.netInfoMap = netInfoMap;
    }

    public String createHeader() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.netInfoMap.keySet()) {
            sb.append(",interface_" + key + "_rx_bytes_sum" + ",interface_" + key + "_tx_bytes_sum");
        }
        return sb.toString();
    }

    public String createEntries() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.netInfoMap.keySet()) {
            sb.append("," + this.netInfoMap.get(key).getRxBytes() + "," + this.netInfoMap.get(key).getTxBytes());
        }
        return sb.toString();
    }

    public String toString() {
        return "NetInfo [netInfoMap=" + this.netInfoMap + "]";
    }

    class NetInfoEntry
    implements Serializable {
        private static final long serialVersionUID = -7279516312913824339L;
        private long rxBytes;
        private long txBytes;

        public NetInfoEntry(long rxBytes, long txBytes) {
            this.rxBytes = rxBytes;
            this.txBytes = txBytes;
        }

        public long getRxBytes() {
            return this.rxBytes;
        }

        public void decrementRxBytes(long rxBytes) {
            this.rxBytes -= rxBytes;
        }

        public long getTxBytes() {
            return this.txBytes;
        }

        public void decrementTxBytes(long txBytes) {
            this.txBytes -= txBytes;
        }

        public String toString() {
            return "NetInfoEntry [rxBytes=" + this.rxBytes + ", txBytes=" + this.txBytes + "]";
        }
    }
}

