/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.io.FilenameUtils;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class Save
implements Command {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String JMX_FILE_EXTENSION = ".jmx";
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doAction(ActionEvent e) throws IllegalUserActionException {
        HashTree subTree = null;
        boolean fullSave = false;
        if (!commands.contains(e.getActionCommand())) {
            throw new IllegalUserActionException("Invalid user command:" + e.getActionCommand());
        }
        if (e.getActionCommand().equals("save_as")) {
            JMeterTreeNode[] nodes = GuiPackage.getInstance().getTreeListener().getSelectedNodes();
            if (nodes.length > 1) {
                JMeterUtils.reportErrorToUser(JMeterUtils.getResString("save_as_error"), JMeterUtils.getResString("save_as"));
                return;
            }
            subTree = GuiPackage.getInstance().getCurrentSubTree();
        } else {
            fullSave = true;
            subTree = GuiPackage.getInstance().getTreeModel().getTestPlan();
        }
        String updateFile = GuiPackage.getInstance().getTestPlanFile();
        if (!"save".equals(e.getActionCommand()) || updateFile == null) {
            int response;
            File f;
            JFileChooser chooser = FileDialoger.promptToSaveFile(updateFile == null ? GuiPackage.getInstance().getTreeListener().getCurrentNode().getName() + JMX_FILE_EXTENSION : updateFile);
            if (chooser == null) {
                return;
            }
            updateFile = chooser.getSelectedFile().getAbsolutePath();
            if (FilenameUtils.getExtension((String)updateFile).equals("")) {
                updateFile = updateFile + JMX_FILE_EXTENSION;
            }
            if ((f = new File(updateFile)).exists() && ((response = JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("save_overwrite_existing_file"), JMeterUtils.getResString("save?"), 0, 3)) == -1 || response == 1)) {
                return;
            }
            if (!e.getActionCommand().equals("save_as")) {
                GuiPackage.getInstance().setTestPlanFile(updateFile);
            }
        }
        try {
            this.convertSubTree(subTree);
        }
        catch (Exception err) {
            log.warn("Error converting subtree " + err);
        }
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(updateFile);
            SaveService.saveTree(subTree, ostream);
            if (fullSave) {
                subTree = GuiPackage.getInstance().getTreeModel().getTestPlan();
                ActionRouter.getInstance().doActionNow(new ActionEvent(subTree, e.getID(), "sub_tree_saved"));
            }
        }
        catch (Throwable ex) {
            try {
                log.error("Error saving tree:", ex);
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new IllegalUserActionException("Couldn't save test plan to file: " + updateFile, ex);
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(ostream);
                throw throwable;
            }
        }
        JOrphanUtils.closeQuietly((Closeable)ostream);
        GuiPackage.getInstance().updateCurrentGui();
    }

    void convertSubTree(HashTree tree) {
        for (JMeterTreeNode item : new LinkedList(tree.list())) {
            this.convertSubTree(tree.getTree((Object)item));
            TestElement testElement = item.getTestElement();
            tree.replace((Object)item, (Object)testElement);
        }
    }

    static {
        commands.add("save_as");
        commands.add("save_all_as");
        commands.add("save");
    }
}

