/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.tree;

import java.awt.Image;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.jmeter.gui.GUIFactory;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.NamedTreeNode;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.log.Logger;

public class JMeterTreeNode
extends DefaultMutableTreeNode
implements NamedTreeNode {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final int TEST_PLAN_LEVEL = 1;
    private final JMeterTreeModel treeModel;
    private boolean markedBySearch;

    public JMeterTreeNode() {
        this(null, null);
    }

    public JMeterTreeNode(TestElement userObj, JMeterTreeModel treeModel) {
        super(userObj);
        this.treeModel = treeModel;
    }

    public boolean isEnabled() {
        return ((AbstractTestElement)this.getTestElement()).getPropertyAsBoolean("TestElement.enabled");
    }

    public void setEnabled(boolean enabled) {
        this.getTestElement().setProperty(new BooleanProperty("TestElement.enabled", enabled));
        this.treeModel.nodeChanged(this);
    }

    public List<JMeterTreeNode> getPathToThreadGroup() {
        ArrayList<JMeterTreeNode> nodes = new ArrayList<JMeterTreeNode>();
        if (this.treeModel != null) {
            TreeNode[] nodesToRoot = this.treeModel.getPathToRoot(this);
            for (int i = 0; i < nodesToRoot.length; ++i) {
                JMeterTreeNode jMeterTreeNode = (JMeterTreeNode)nodesToRoot[i];
                int level = jMeterTreeNode.getLevel();
                if (level < 1) continue;
                nodes.add(jMeterTreeNode);
            }
        }
        return nodes;
    }

    public void setMarkedBySearch(boolean tagged) {
        this.markedBySearch = tagged;
        this.treeModel.nodeChanged(this);
    }

    public boolean isMarkedBySearch() {
        return this.markedBySearch;
    }

    public ImageIcon getIcon() {
        return this.getIcon(true);
    }

    public ImageIcon getIcon(boolean enabled) {
        TestElement testElement = this.getTestElement();
        try {
            if (testElement instanceof TestBean) {
                Class<?> testClass = testElement.getClass();
                try {
                    Image img = Introspector.getBeanInfo(testClass).getIcon(1);
                    if (img == null) {
                        Object clazz = Introspector.getBeanInfo(testClass).getBeanDescriptor().getValue("TestElement.gui_class");
                        if (clazz == null) {
                            log.warn("getIcon(): Can't obtain GUI class from " + testClass.getName());
                            return null;
                        }
                        return GUIFactory.getIcon(Class.forName((String)clazz), enabled);
                    }
                    return new ImageIcon(img);
                }
                catch (IntrospectionException e1) {
                    log.error("Can't obtain icon for class " + testElement, (Throwable)e1);
                    throw new JMeterError((Throwable)e1);
                }
            }
            return GUIFactory.getIcon(Class.forName(testElement.getPropertyAsString("TestElement.gui_class")), enabled);
        }
        catch (ClassNotFoundException e) {
            log.warn("Can't get icon for class " + testElement, (Throwable)e);
            return null;
        }
    }

    public Collection<String> getMenuCategories() {
        try {
            return GuiPackage.getInstance().getGui(this.getTestElement()).getMenuCategories();
        }
        catch (Exception e) {
            log.error("Can't get popup menu for gui", (Throwable)e);
            return null;
        }
    }

    public JPopupMenu createPopupMenu() {
        try {
            return GuiPackage.getInstance().getGui(this.getTestElement()).createPopupMenu();
        }
        catch (Exception e) {
            log.error("Can't get popup menu for gui", (Throwable)e);
            return null;
        }
    }

    public TestElement getTestElement() {
        return (TestElement)this.getUserObject();
    }

    public String getStaticLabel() {
        return GuiPackage.getInstance().getGui((TestElement)this.getUserObject()).getStaticLabel();
    }

    public String getDocAnchor() {
        return GuiPackage.getInstance().getGui((TestElement)this.getUserObject()).getDocAnchor();
    }

    @Override
    public void setName(String name) {
        ((TestElement)this.getUserObject()).setName(name);
    }

    @Override
    public String getName() {
        return ((TestElement)this.getUserObject()).getName();
    }

    @Override
    public void nameChanged() {
        if (this.treeModel != null) {
            this.treeModel.nodeChanged(this);
        }
    }

    public Enumeration<JMeterTreeNode> children() {
        return super.children();
    }
}

