/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.lang.reflect.Constructor;
import org.apache.jmeter.samplers.AsynchSampleSender;
import org.apache.jmeter.samplers.BatchSampleSender;
import org.apache.jmeter.samplers.DataStrippingSampleSender;
import org.apache.jmeter.samplers.DiskStoreSampleSender;
import org.apache.jmeter.samplers.HoldSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleSender;
import org.apache.jmeter.samplers.StandardSampleSender;
import org.apache.jmeter.samplers.StatisticalSampleSender;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SampleSenderFactory {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String MODE_STANDARD = "Standard";
    private static final String MODE_HOLD = "Hold";
    private static final String MODE_BATCH = "Batch";
    private static final String MODE_STATISTICAL = "Statistical";
    private static final String MODE_STRIPPED = "Stripped";
    private static final String MODE_STRIPPED_BATCH = "StrippedBatch";
    private static final String MODE_ASYNCH = "Asynch";
    private static final String MODE_DISKSTORE = "DiskStore";

    static SampleSender getInstance(RemoteSampleListener listener) {
        boolean holdSamples = JMeterUtils.getPropDefault("hold_samples", false);
        String type = JMeterUtils.getPropDefault("mode", MODE_STRIPPED_BATCH);
        if (holdSamples || type.equalsIgnoreCase(MODE_HOLD)) {
            HoldSampleSender h = new HoldSampleSender(listener);
            return h;
        }
        if (type.equalsIgnoreCase(MODE_BATCH)) {
            BatchSampleSender b = new BatchSampleSender(listener);
            return b;
        }
        if (type.equalsIgnoreCase(MODE_STATISTICAL)) {
            StatisticalSampleSender s = new StatisticalSampleSender(listener);
            return s;
        }
        if (type.equalsIgnoreCase(MODE_STANDARD)) {
            StandardSampleSender s = new StandardSampleSender(listener);
            return s;
        }
        if (type.equalsIgnoreCase(MODE_STRIPPED_BATCH)) {
            return new DataStrippingSampleSender(new BatchSampleSender(listener));
        }
        if (type.equalsIgnoreCase(MODE_STRIPPED)) {
            return new DataStrippingSampleSender(listener);
        }
        if (type.equalsIgnoreCase(MODE_ASYNCH)) {
            return new AsynchSampleSender(listener);
        }
        if (type.equalsIgnoreCase(MODE_DISKSTORE)) {
            return new DiskStoreSampleSender(listener);
        }
        SampleSender s = null;
        try {
            Class<?> clazz = Class.forName(type);
            Constructor<?> cons = clazz.getConstructor(RemoteSampleListener.class);
            s = (SampleSender)cons.newInstance(listener);
        }
        catch (Exception e) {
            log.error("Unable to create a sample sender from class " + type);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return s;
    }
}

