/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save.converters;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.NameUpdater;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ConversionHelp {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String CHAR_SET = "UTF-8";
    public static final String ATT_CLASS = "class";
    public static final String ATT_NAME = "name";
    public static final String ATT_ELEMENT_TYPE = "elementType";
    private static final String ATT_TE_ENABLED = "enabled";
    private static final String ATT_TE_TESTCLASS = "testclass";
    static final String ATT_TE_GUICLASS = "guiclass";
    private static final String ATT_TE_NAME = "testname";
    private static String inVersion;
    private static String outVersion;
    private static final Map<String, String> propertyToAttribute;

    public static void setInVersion(String v) {
        inVersion = v;
    }

    public static void setOutVersion(String v) {
        outVersion = v;
    }

    public static String encode(String p) {
        if (p == null) {
            return "";
        }
        if (!"1.0".equals(outVersion)) {
            return p;
        }
        try {
            String p1 = URLEncoder.encode(p, CHAR_SET);
            return p1;
        }
        catch (UnsupportedEncodingException e) {
            log.warn("System doesn't support UTF-8", (Throwable)e);
            return p;
        }
    }

    public static String decode(String p) {
        if (!"1.0".equals(inVersion)) {
            return p;
        }
        if (p == null) {
            return null;
        }
        try {
            return URLDecoder.decode(p, CHAR_SET);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("System doesn't support UTF-8", (Throwable)e);
            return p;
        }
    }

    public static String cdata(byte[] chars, String encoding) throws UnsupportedEncodingException {
        StringBuilder buf = new StringBuilder("<![CDATA[");
        buf.append(new String(chars, encoding));
        buf.append("]]>");
        return buf.toString();
    }

    private static void mapentry(String prop, String att) {
        propertyToAttribute.put(prop, att);
    }

    private static void saveClass(TestElement el, HierarchicalStreamWriter writer, String prop) {
        String clazz = el.getPropertyAsString(prop);
        if (clazz.length() > 0) {
            writer.addAttribute(propertyToAttribute.get(prop), SaveService.classToAlias(clazz));
        }
    }

    private static void restoreClass(TestElement el, HierarchicalStreamReader reader, String prop) {
        String att = propertyToAttribute.get(prop);
        String alias = reader.getAttribute(att);
        if (alias != null) {
            alias = SaveService.aliasToClass(alias);
            if ("TestElement.gui_class".equals(prop)) {
                alias = NameUpdater.getCurrentName(alias);
            }
            el.setProperty(prop, alias);
        }
    }

    private static void saveItem(TestElement el, HierarchicalStreamWriter writer, String prop, boolean encode) {
        String item = el.getPropertyAsString(prop);
        if (item.length() > 0) {
            if (encode) {
                item = ConversionHelp.encode(item);
            }
            writer.addAttribute(propertyToAttribute.get(prop), item);
        }
    }

    private static void restoreItem(TestElement el, HierarchicalStreamReader reader, String prop, boolean decode) {
        String att = propertyToAttribute.get(prop);
        String value = reader.getAttribute(att);
        if (value != null) {
            if (decode) {
                value = ConversionHelp.decode(value);
            }
            el.setProperty(prop, value);
        }
    }

    public static boolean isSpecialProperty(String name) {
        return propertyToAttribute.containsKey(name);
    }

    public static String getPropertyName(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String name = ConversionHelp.decode(reader.getAttribute(ATT_NAME));
        return ConversionHelp.getUpgradePropertyName(name, context);
    }

    public static String getPropertyValue(HierarchicalStreamReader reader, UnmarshallingContext context, String name) {
        String value = ConversionHelp.decode(reader.getValue());
        return ConversionHelp.getUpgradePropertyValue(name, value, context);
    }

    public static String getUpgradePropertyName(String name, UnmarshallingContext context) {
        String testClass = (String)context.get((Object)"TestClassName");
        String newName = NameUpdater.getCurrentName(name, testClass);
        if (name.length() != 0 && newName.length() == 0) {
            return null;
        }
        return newName;
    }

    public static String getUpgradePropertyValue(String name, String value, UnmarshallingContext context) {
        String testClass = (String)context.get((Object)"TestClassName");
        return NameUpdater.getCurrentName(value, name, testClass);
    }

    public static void saveSpecialProperties(TestElement testElement, HierarchicalStreamWriter writer) {
        ConversionHelp.saveClass(testElement, writer, "TestElement.gui_class");
        ConversionHelp.saveClass(testElement, writer, "TestElement.test_class");
        ConversionHelp.saveItem(testElement, writer, "TestElement.name", true);
        ConversionHelp.saveItem(testElement, writer, "TestElement.enabled", false);
    }

    public static void restoreSpecialProperties(TestElement testElement, HierarchicalStreamReader reader) {
        ConversionHelp.restoreClass(testElement, reader, "TestElement.gui_class");
        ConversionHelp.restoreClass(testElement, reader, "TestElement.test_class");
        ConversionHelp.restoreItem(testElement, reader, "TestElement.name", true);
        ConversionHelp.restoreItem(testElement, reader, "TestElement.enabled", false);
    }

    static {
        outVersion = "1.1";
        propertyToAttribute = new HashMap<String, String>();
        ConversionHelp.mapentry("TestElement.name", ATT_TE_NAME);
        ConversionHelp.mapentry("TestElement.gui_class", ATT_TE_GUICLASS);
        ConversionHelp.mapentry("TestElement.test_class", ATT_TE_TESTCLASS);
        ConversionHelp.mapentry("TestElement.enabled", ATT_TE_ENABLED);
    }
}

