/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import javax.swing.JOptionPane;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.testbeans.gui.ComboStringEditor;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

class WrapperEditor
extends PropertyEditorSupport
implements PropertyChangeListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final PropertyEditor typeEditor;
    private final PropertyEditor guiEditor;
    private final boolean acceptsNull;
    private final boolean acceptsExpressions;
    private final boolean acceptsOther;
    private final Object defaultValue;
    private String lastValidValue = null;

    WrapperEditor(Object source, PropertyEditor typeEditor, PropertyEditor guiEditor, boolean acceptsNull, boolean acceptsExpressions, boolean acceptsOther, Object defaultValue) {
        if (source != null) {
            super.setSource(source);
        }
        this.typeEditor = typeEditor;
        this.guiEditor = guiEditor;
        this.acceptsNull = acceptsNull;
        this.acceptsExpressions = acceptsExpressions;
        this.acceptsOther = acceptsOther;
        this.defaultValue = defaultValue;
        this.initialize();
    }

    WrapperEditor(PropertyEditor typeEditor, PropertyEditor guiEditor, boolean acceptsNull, boolean acceptsExpressions, boolean acceptsOther, Object defaultValue) {
        this(null, typeEditor, guiEditor, acceptsNull, acceptsExpressions, acceptsOther, defaultValue);
    }

    final void resetValue() {
        this.setValue(this.defaultValue);
        this.lastValidValue = this.getAsText();
    }

    private void initialize() {
        this.resetValue();
        if (this.guiEditor instanceof ComboStringEditor) {
            String[] tags = ((ComboStringEditor)this.guiEditor).getTags();
            String v = !this.acceptsOther ? "${}" : (this.isValidValue("") ? "" : (this.acceptsExpressions ? "${}" : (tags != null && tags.length > 0 ? tags[0] : this.getAsText())));
            ((ComboStringEditor)this.guiEditor).setInitialEditValue(v);
        }
        this.guiEditor.addPropertyChangeListener(this);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.guiEditor.getCustomEditor();
    }

    @Override
    public String[] getTags() {
        return this.guiEditor.getTags();
    }

    private boolean isATag(String text) {
        String[] tags = this.getTags();
        if (tags == null) {
            return false;
        }
        for (int i = 0; i < tags.length; ++i) {
            if (!tags[i].equals(text)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidValue(String text) {
        if (text == null) {
            return this.acceptsNull;
        }
        if (this.acceptsExpressions && this.isExpression(text)) {
            return true;
        }
        if (this.isATag(text)) {
            return true;
        }
        if (!this.acceptsOther) {
            return false;
        }
        try {
            this.typeEditor.setAsText(text);
        }
        catch (IllegalArgumentException e1) {
            return false;
        }
        return true;
    }

    private final void shouldNeverHappen(String msg) throws Error {
        throw new Error(msg);
    }

    private final void shouldNeverHappen(Exception e) throws Error {
        throw new Error(e.toString());
    }

    private final boolean isExpression(String text) {
        return text.indexOf("${") != -1;
    }

    private final boolean isExpression(Object text) {
        return text instanceof String && this.isExpression((String)text);
    }

    @Override
    public Object getValue() {
        Object value;
        String text = (String)this.guiEditor.getValue();
        if (text == null) {
            if (!this.acceptsNull) {
                this.shouldNeverHappen("Text is null but null is not allowed");
            }
            value = null;
        } else if (this.acceptsExpressions && this.isExpression(text)) {
            value = text;
        } else {
            block12: {
                if (!this.acceptsOther && !this.isATag(text)) {
                    this.shouldNeverHappen("Text is not a tag but other entries are not allowed");
                }
                try {
                    try {
                        this.typeEditor.setAsText(text);
                    }
                    catch (NumberFormatException e) {
                        if (text.length() == 0) {
                            text = "0";
                            this.typeEditor.setAsText(text);
                            break block12;
                        }
                        this.shouldNeverHappen(e);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.shouldNeverHappen(e);
                }
            }
            value = this.typeEditor.getValue();
        }
        if (log.isDebugEnabled()) {
            log.debug("->" + (value != null ? value.getClass().getName() : "NULL") + ":" + value);
        }
        return value;
    }

    @Override
    public final void setValue(Object value) {
        String text;
        if (log.isDebugEnabled()) {
            log.debug("<-" + (value != null ? value.getClass().getName() : "NULL") + ":" + value);
        }
        if (value == null) {
            if (!this.acceptsNull) {
                throw new IllegalArgumentException("Null is not allowed");
            }
            text = null;
        } else if (this.acceptsExpressions && this.isExpression(value)) {
            text = (String)value;
        } else {
            this.typeEditor.setValue(value);
            text = this.fixGetAsTextBug(this.typeEditor.getAsText());
            if (!this.acceptsOther && !this.isATag(text)) {
                throw new IllegalArgumentException("Value not allowed: " + text);
            }
        }
        this.guiEditor.setValue(text);
    }

    private String fixGetAsTextBug(String asText) {
        if (asText == null) {
            return asText;
        }
        if (asText.equals("true")) {
            log.debug("true=>True");
            return "True";
        }
        if (asText.equals("false")) {
            log.debug("false=>False");
            return "False";
        }
        return asText;
    }

    @Override
    public String getAsText() {
        String text = this.fixGetAsTextBug(this.guiEditor.getAsText());
        if (text == null) {
            if (!this.acceptsNull) {
                this.shouldNeverHappen("Text is null, but null is not allowed");
            }
        } else if (!this.acceptsExpressions || !this.isExpression(text)) {
            try {
                this.typeEditor.setAsText(text);
            }
            catch (IllegalArgumentException e) {
                this.shouldNeverHappen(e);
            }
            text = this.fixGetAsTextBug(this.typeEditor.getAsText());
            if (!this.acceptsOther && !this.isATag(text)) {
                this.shouldNeverHappen("Text is not a tag, but other values are not allowed");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("->\"" + text + "\"");
        }
        return text;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String value;
        if (log.isDebugEnabled()) {
            log.debug(text == null ? "<-null" : "<-\"" + text + "\"");
        }
        if (text == null) {
            if (!this.acceptsNull) {
                throw new IllegalArgumentException("Null parameter not allowed");
            }
            value = null;
        } else if (this.acceptsExpressions && this.isExpression(text)) {
            value = text;
        } else {
            this.typeEditor.setAsText(text);
            value = this.typeEditor.getAsText();
            if (!this.acceptsOther && !this.isATag(text)) {
                throw new IllegalArgumentException("Value not allowed: " + text);
            }
        }
        this.guiEditor.setValue(value);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String text = this.fixGetAsTextBug(this.guiEditor.getAsText());
        if (this.isValidValue(text)) {
            this.lastValidValue = text;
            this.firePropertyChange();
        } else {
            if (GuiPackage.getInstance() == null) {
                log.warn("Invalid value: " + text + " " + this.typeEditor);
            } else {
                JOptionPane.showMessageDialog(this.guiEditor.getCustomEditor().getParent(), JMeterUtils.getResString("property_editor.value_is_invalid_message"), JMeterUtils.getResString("property_editor.value_is_invalid_title"), 2);
            }
            this.guiEditor.setAsText(this.lastValidValue);
        }
    }
}

