/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

public class CPSPauser {
    private final int CPS;
    private static final int MS_PER_SEC = 1000;
    private static final int NS_PER_SEC = 1000000000;
    private static final int NS_PER_MS = 1000000;

    public CPSPauser(int cps) {
        if (cps <= 0) {
            throw new IllegalArgumentException("Speed (cps) <= 0");
        }
        this.CPS = cps;
    }

    public void pause(int bytes) {
        long sleepMS = bytes * 1000 / this.CPS;
        int sleepNS = bytes * 1000 / this.CPS % 1000000;
        try {
            Thread.sleep(sleepMS, sleepNS);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
    }
}

