/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util.keystore;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public final class JmeterKeyStore {
    private static final Logger LOG = LoggingManager.getLoggerForClass();
    private final KeyStore store;
    private final int startIndex;
    private final int endIndex;
    private X509Certificate[][] certChains;
    private PrivateKey[] keys;
    private String[] names = new String[0];
    private int last_user;

    private JmeterKeyStore(String type, int startIndex, int endIndex) throws Exception {
        if (startIndex < 0 || endIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException("Invalid index(es). Start=" + startIndex + ", end=" + endIndex);
        }
        this.store = KeyStore.getInstance(type);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public void load(InputStream is, String pword) throws Exception {
        char[] pw = pword == null ? null : pword.toCharArray();
        this.store.load(is, pw);
        ArrayList<String> v_names = new ArrayList<String>();
        ArrayList<PrivateKey> v_keys = new ArrayList<PrivateKey>();
        ArrayList<X509Certificate[]> v_certChains = new ArrayList<X509Certificate[]>();
        if (null != is) {
            PrivateKey _key = null;
            int index = 0;
            Enumeration<String> aliases = this.store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this.store.isKeyEntry(alias)) continue;
                if (index >= this.startIndex && index <= this.endIndex) {
                    _key = (PrivateKey)this.store.getKey(alias, pw);
                    if (null == _key) {
                        throw new Exception("No key found for alias: " + alias);
                    }
                    Certificate[] chain = this.store.getCertificateChain(alias);
                    if (null == chain) {
                        throw new Exception("No certificate chain found for alias: " + alias);
                    }
                    v_names.add(alias);
                    v_keys.add(_key);
                    X509Certificate[] x509certs = new X509Certificate[chain.length];
                    for (int i = 0; i < x509certs.length; ++i) {
                        x509certs[i] = (X509Certificate)chain[i];
                    }
                    v_certChains.add(x509certs);
                }
                ++index;
            }
            if (null == _key) {
                throw new Exception("No key(s) found");
            }
            if (index <= this.endIndex - this.startIndex) {
                LOG.warn("Did not find all requested aliases. Start=" + this.startIndex + ", end=" + this.endIndex + ", found=" + v_certChains.size());
            }
        }
        int v_size = v_names.size();
        this.names = new String[v_size];
        this.names = v_names.toArray(this.names);
        this.keys = new PrivateKey[v_size];
        this.keys = v_keys.toArray(this.keys);
        this.certChains = new X509Certificate[v_size][];
        this.certChains = (X509Certificate[][])v_certChains.toArray((T[])this.certChains);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        int entry = this.findAlias(alias);
        if (entry >= 0) {
            return this.certChains[entry];
        }
        return null;
    }

    public String getAlias() {
        int length = this.names.length;
        if (length == 0) {
            return null;
        }
        return this.names[this.getIndexAndIncrement(length)];
    }

    public int getAliasCount() {
        return this.names.length;
    }

    public String getAlias(int index) {
        int length = this.names.length;
        if (length == 0 && index == 0) {
            return null;
        }
        if (index >= length || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.names[index];
    }

    public PrivateKey getPrivateKey(String alias) {
        int entry = this.findAlias(alias);
        if (entry >= 0) {
            return this.keys[entry];
        }
        return null;
    }

    public static JmeterKeyStore getInstance(String type, int startIndex, int endIndex) throws Exception {
        return new JmeterKeyStore(type, startIndex, endIndex);
    }

    public static JmeterKeyStore getInstance(String type) throws Exception {
        return new JmeterKeyStore(type, 0, 0);
    }

    private int findAlias(String alias) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!alias.equals(this.names[i])) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIndexAndIncrement(int length) {
        JmeterKeyStore jmeterKeyStore = this;
        synchronized (jmeterKeyStore) {
            int result = this.last_user++;
            if (this.last_user >= length) {
                this.last_user = 0;
            }
            return result;
        }
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        int count = this.getAliasCount();
        String[] aliases = new String[count];
        for (int i = 0; i < aliases.length; ++i) {
            aliases[i] = this.names[i];
        }
        if (aliases.length > 0) {
            return aliases;
        }
        return null;
    }
}

